/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class PotentiallyMultiValuedMap
implements Recyclable {
    private final List<String> keys;
    private final List<Object> values;

    public PotentiallyMultiValuedMap() {
        this(10);
    }

    public PotentiallyMultiValuedMap(int initialSize) {
        this.keys = new ArrayList<String>(initialSize);
        this.values = new ArrayList<Object>(initialSize);
    }

    public void add(String key, String value) {
        int index = this.indexOfIgnoreCase(key);
        if (index >= 0) {
            Object previousValue = this.values.get(index);
            if (previousValue instanceof List) {
                this.addValueToValueList(value, (List)previousValue);
            } else {
                this.convertValueToMultiValue(index, (String)previousValue, value);
            }
        } else {
            this.keys.add(key);
            this.values.add(value);
        }
    }

    public void set(String key, String[] values) {
        if (values.length > 0) {
            if (values.length == 1) {
                this.keys.add(key);
                this.values.add(values[0]);
            } else {
                this.keys.add(key);
                this.values.add(Arrays.asList(values));
            }
        }
    }

    private int indexOfIgnoreCase(String key) {
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!this.keys.get(i).equalsIgnoreCase(key)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public String getFirst(String key) {
        Object valueOrValueList = this.get(key);
        if (valueOrValueList instanceof List) {
            return (String)((List)valueOrValueList).get(0);
        }
        return (String)valueOrValueList;
    }

    @Nullable
    public Object get(String key) {
        int index = this.indexOfIgnoreCase(key);
        if (index == -1) {
            return null;
        }
        return this.values.get(index);
    }

    public List<String> getAll(String key) {
        int index = this.indexOfIgnoreCase(key);
        if (index == -1) {
            return Collections.emptyList();
        }
        Object valueOrValueList = this.values.get(index);
        if (valueOrValueList instanceof List) {
            return (List)valueOrValueList;
        }
        return Collections.singletonList((String)valueOrValueList);
    }

    private void addValueToValueList(String value, List<String> valueList) {
        valueList.add(value);
    }

    private void convertValueToMultiValue(int index, String previousValue, String value) {
        ArrayList<String> valueList = new ArrayList<String>(4);
        valueList.add(previousValue);
        valueList.add(value);
        this.values.set(index, valueList);
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public void resetState() {
        this.keys.clear();
        this.values.clear();
    }

    public String getKey(int i) {
        return this.keys.get(i);
    }

    public Object getValue(int i) {
        return this.values.get(i);
    }

    public int size() {
        return this.keys.size();
    }

    public void copyFrom(PotentiallyMultiValuedMap other) {
        this.keys.addAll(other.keys);
        this.values.addAll(other.values);
    }

    public void removeIgnoreCase(String key) {
        int index = this.indexOfIgnoreCase(key);
        if (index != -1) {
            this.keys.remove(index);
            this.values.remove(index);
        }
    }

    public void set(int index, String value) {
        this.values.set(index, value);
    }

    public boolean containsIgnoreCase(String key) {
        return this.indexOfIgnoreCase(key) != -1;
    }
}

