/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class PackageScanner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getClassNames(String basePackage, ClassLoader classLoader) throws IOException, URISyntaxException {
        List<String> list;
        try {
            list = PackageScanner.doGetClassNames(basePackage, classLoader);
        }
        catch (ClosedByInterruptException e) {
            boolean interrupted = Thread.interrupted();
            try {
                list = PackageScanner.doGetClassNames(basePackage, classLoader);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static List<String> doGetClassNames(String basePackage, ClassLoader classLoader) throws IOException, URISyntaxException {
        String baseFolderResource = basePackage.replace('.', '/');
        ArrayList<String> classNames = new ArrayList<String>();
        Enumeration<URL> resources = classLoader.getResources(baseFolderResource);
        while (resources.hasMoreElements()) {
            List<String> result;
            URL resource = resources.nextElement();
            URI uri = resource.toURI();
            if (uri.getScheme().equals("jar")) {
                block12: {
                    Class<PackageScanner> clazz = PackageScanner.class;
                    // MONITORENTER : co.elastic.apm.agent.util.PackageScanner.class
                    FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    try {
                        Path basePath = fileSystem.getPath(baseFolderResource, new String[0]).toAbsolutePath();
                        if (!Files.exists(basePath, new LinkOption[0])) {
                            basePath = fileSystem.getPath("agent/" + baseFolderResource, new String[0]).toAbsolutePath();
                        }
                        result = PackageScanner.listClassNames(basePackage, basePath);
                        break;
                    }
                    finally {
                        if (fileSystem == null) break block12;
                        fileSystem.close();
                    }
                }
                // MONITOREXIT : clazz
            } else {
                result = PackageScanner.listClassNames(basePackage, Paths.get(uri));
            }
            classNames.addAll(result);
        }
        return classNames;
    }

    private static List<String> listClassNames(final String basePackage, final Path basePath) throws IOException {
        final ArrayList<String> classNames = new ArrayList<String>();
        Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toString().endsWith(".class") || file.toString().endsWith(".esclazz")) {
                    String classNameSuffix = basePath.relativize(file).toString().replace(System.getProperty("file.separator"), ".").replace('/', '.').replace(".class", "").replace(".esclazz", "");
                    classNames.add(basePackage + "." + classNameSuffix);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return classNames;
    }
}

