/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class JmxUtils {
    private static final Logger logger = LoggerFactory.getLogger(JmxUtils.class);
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean");
    private static final List<String> THREAD_BEAN_CLASS_NAMES = Arrays.asList("com.sun.management.ThreadMXBean");
    @Nullable
    private static Class<?> operatingSystemBeanClass;
    private static boolean operatingSystemBeanClassInitialized;
    @Nullable
    private static Class<?> threadBeanClass;
    private static boolean threadBeanClassInitialized;

    @Nullable
    public static Method getOperatingSystemMBeanMethod(OperatingSystemMXBean operatingSystemBean, String methodName) {
        JmxUtils.initOsBeanClass();
        return JmxUtils.tryLookupMethod(operatingSystemBean, operatingSystemBeanClass, methodName, new Class[0]);
    }

    public static boolean isIbmOperatingSystemMBean() {
        JmxUtils.initThreadBeanClass();
        return threadBeanClass != null && "com.ibm.lang.management.OperatingSystemMXBean".equals(threadBeanClass.getName());
    }

    @Nullable
    public static Method getThreadMBeanMethod(ThreadMXBean threadBean, String methodName, Class<?> ... parameterTypes) {
        JmxUtils.initThreadBeanClass();
        return JmxUtils.tryLookupMethod(threadBean, threadBeanClass, methodName, parameterTypes);
    }

    private static synchronized void initOsBeanClass() {
        if (operatingSystemBeanClassInitialized) {
            return;
        }
        operatingSystemBeanClassInitialized = true;
        operatingSystemBeanClass = JmxUtils.tryLoadBeanClass("OperatingSystemMXBean", OPERATING_SYSTEM_BEAN_CLASS_NAMES);
    }

    private static synchronized void initThreadBeanClass() {
        if (threadBeanClassInitialized) {
            return;
        }
        threadBeanClassInitialized = true;
        threadBeanClass = JmxUtils.tryLoadBeanClass("ThreadMXBean", THREAD_BEAN_CLASS_NAMES);
    }

    @Nullable
    private static Class<?> tryLoadBeanClass(String beanName, List<String> candidates) {
        try {
            for (String className : candidates) {
                try {
                    Class<?> beanClass = Class.forName(className);
                    logger.info("Found JVM-specific {} interface: {}", (Object)beanName, (Object)className);
                    return beanClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        catch (Throwable throwable) {
            logger.error("Failed to load {} implementation", (Object)beanName, (Object)throwable);
        }
        return null;
    }

    @Nullable
    private static Method tryLookupMethod(Object beanInstance, @Nullable Class<?> expectedBeanClass, String methodName, Class<?> ... parameterTypes) {
        if (expectedBeanClass == null) {
            return null;
        }
        try {
            expectedBeanClass.cast(beanInstance);
            return expectedBeanClass.getMethod(methodName, parameterTypes);
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }
}

