/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class IOUtils {
    protected static final int BYTE_BUFFER_CAPACITY = 2048;
    protected static final ThreadLocal<ByteBuffer> threadLocalByteBuffer = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(2048);
        }
    };
    protected static final ThreadLocal<CharsetDecoder> threadLocalCharsetDecoder = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return StandardCharsets.UTF_8.newDecoder();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readUtf8Stream(InputStream is, CharBuffer charBuffer) throws IOException {
        ByteBuffer buffer = threadLocalByteBuffer.get();
        CharsetDecoder charsetDecoder = threadLocalCharsetDecoder.get();
        try {
            byte[] bufferArray = buffer.array();
            int read = is.read(bufferArray);
            while (read != -1) {
                ((Buffer)buffer).limit(read);
                CoderResult coderResult = charsetDecoder.decode(buffer, charBuffer, true);
                ((Buffer)buffer).clear();
                if (coderResult.isError()) {
                    ((Buffer)charBuffer).clear();
                    boolean bl = false;
                    return bl;
                }
                if (coderResult.isOverflow()) break;
                read = is.read(bufferArray);
            }
            charsetDecoder.flush(charBuffer);
            boolean bl = true;
            return bl;
        }
        finally {
            ((Buffer)charBuffer).flip();
            ((Buffer)buffer).clear();
            charsetDecoder.reset();
            is.close();
        }
    }

    public static CoderResult decodeUtf8Bytes(byte[] bytes, CharBuffer charBuffer) {
        return IOUtils.decodeUtf8Bytes(bytes, 0, bytes.length, charBuffer);
    }

    public static CoderResult decodeUtf8Bytes(byte[] bytes, int offset, int length, CharBuffer charBuffer) {
        ByteBuffer buffer;
        if (2048 < length) {
            buffer = ByteBuffer.wrap(bytes, offset, length);
        } else {
            buffer = threadLocalByteBuffer.get();
            buffer.put(bytes, offset, length);
            ((Buffer)buffer).position(0);
            ((Buffer)buffer).limit(length);
        }
        return IOUtils.decode(charBuffer, buffer);
    }

    public static CoderResult decodeUtf8Byte(byte b, CharBuffer charBuffer) {
        ByteBuffer buffer = threadLocalByteBuffer.get();
        buffer.put(b);
        ((Buffer)buffer).position(0);
        ((Buffer)buffer).limit(1);
        return IOUtils.decode(charBuffer, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CoderResult decode(CharBuffer charBuffer, ByteBuffer buffer) {
        CharsetDecoder charsetDecoder = threadLocalCharsetDecoder.get();
        try {
            CoderResult coderResult = charsetDecoder.decode(buffer, charBuffer, true);
            charsetDecoder.flush(charBuffer);
            CoderResult coderResult2 = coderResult;
            return coderResult2;
        }
        finally {
            ((Buffer)buffer).clear();
            charsetDecoder.reset();
        }
    }
}

