/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class AtomicDouble {
    private volatile long valueBits;
    private static final AtomicLongFieldUpdater<AtomicDouble> valueUpdater = AtomicLongFieldUpdater.newUpdater(AtomicDouble.class, "valueBits");

    public AtomicDouble() {
        this(0.0);
    }

    public AtomicDouble(double initialValue) {
        this.valueBits = Double.doubleToLongBits(initialValue);
    }

    public double get() {
        return Double.longBitsToDouble(this.valueBits);
    }

    public void set(double newValue) {
        this.valueBits = Double.doubleToLongBits(newValue);
    }

    public boolean compareAndSet(double expected, double newValue) {
        long expectedLong = Double.doubleToLongBits(expected);
        long expectedDouble = Double.doubleToLongBits(newValue);
        return valueUpdater.compareAndSet(this, expectedLong, expectedDouble);
    }

    public void setWeakMax(double value) {
        for (int i = 0; i < 10; ++i) {
            double current = this.get();
            if (current >= value) {
                return;
            }
            if (!this.compareAndSet(current, value)) continue;
            return;
        }
    }

    public void setWeakMin(double value) {
        for (int i = 0; i < 10; ++i) {
            double current = this.get();
            if (current <= value) {
                return;
            }
            if (!this.compareAndSet(current, value)) continue;
            return;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicDouble that = (AtomicDouble)o;
        return this.get() == that.get();
    }

    public int hashCode() {
        long bits = this.valueBits;
        return (int)(bits ^ bits >>> 32);
    }
}

