/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.tomcatlogging.reformatting;

import co.elastic.apm.agent.jul.reformatting.AbstractJulEcsReformattingHelper;
import co.elastic.apm.agent.loginstr.reformatting.Utils;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import javax.annotation.Nullable;
import org.apache.juli.FileHandler;

public class TomcatReformattingHelper
extends AbstractJulEcsReformattingHelper {
    private static final ThreadLocal<String> currentDirectory = new ThreadLocal();
    private static final ThreadLocal<String> currentPrefix = new ThreadLocal();
    private static final ThreadLocal<String> currentSuffix = new ThreadLocal();

    TomcatReformattingHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAppendEnter(FileHandler fileHandler, String directory, String prefix, String suffix) {
        try {
            currentDirectory.set(directory);
            currentPrefix.set(prefix);
            currentSuffix.set(suffix);
            boolean bl = super.onAppendEnter(fileHandler);
            return bl;
        }
        finally {
            currentDirectory.remove();
            currentPrefix.remove();
            currentSuffix.remove();
        }
    }

    @Override
    @Nullable
    protected String getAppenderName(Handler handler) {
        if (handler instanceof FileHandler) {
            return "FILE";
        }
        return handler.getClass().getSimpleName();
    }

    @Override
    protected String getShadeFilePatternAndCreateDir() throws IOException {
        StringBuilder originalFile = new StringBuilder(currentDirectory.get());
        if (originalFile.charAt(originalFile.length() - 1) != File.separatorChar) {
            originalFile.append(File.separatorChar);
        }
        originalFile.append(currentPrefix.get());
        originalFile.append(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        originalFile.append(currentSuffix.get());
        String pattern = Utils.replaceFileExtensionToEcsJson(originalFile.toString());
        pattern = pattern + ".%g";
        Path destinationPattern = Paths.get(pattern, new String[0]);
        Path destinationDir = Utils.computeLogReformattingDir(destinationPattern, this.getConfiguredReformattingDir());
        if (destinationDir != null) {
            PrivilegedActionUtils.createDirectories(destinationDir);
            pattern = destinationDir.resolve(destinationPattern.getFileName()).toString();
        }
        return pattern;
    }

    @Override
    protected boolean isFileHandler(Handler originalHandler) {
        return originalHandler instanceof FileHandler;
    }
}

