/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.struts;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.struts.StrutsFrameworkUtils;
import co.elastic.apm.agent.util.TransactionNameUtils;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;

public class ActionProxyAdvice {
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object onEnterExecute(@Advice.This ActionProxy actionProxy) {
        Transaction transaction = GlobalTracer.get().currentTransaction();
        if (transaction == null) {
            return null;
        }
        String className = actionProxy.getAction().getClass().getSimpleName();
        String methodName = actionProxy.getMethod();
        if (ActionContext.getContext().get("CHAIN_HISTORY") != null) {
            Span span = ((Span)transaction.createSpan().withType("app")).withSubtype("internal");
            TransactionNameUtils.setNameFromClassAndMethod(className, methodName, span.getAndOverrideName(100));
            return span.activate();
        }
        TransactionNameUtils.setNameFromClassAndMethod(className, methodName, transaction.getAndOverrideName(100));
        StrutsFrameworkUtils.setFrameworkNameAndVersion(transaction);
        return null;
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
    public static void onExitExecute(@Advice.Enter @Nullable Object spanOrNull, @Advice.Thrown @Nullable Throwable t) {
        if (spanOrNull == null) {
            return;
        }
        Span span = (Span)spanOrNull;
        try {
            if (t != null) {
                ((Span)span.captureException(t)).withOutcome(Outcome.FAILURE);
            } else {
                span.withOutcome(Outcome.SUCCESS);
            }
        }
        finally {
            ((Span)span.deactivate()).end();
        }
    }
}

