/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebflux;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.springwebflux.WebFluxInstrumentation;
import co.elastic.apm.agent.springwebflux.WebfluxHelper;
import co.elastic.apm.agent.util.TransactionNameUtils;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HandlerAdapterInstrumentation
extends WebFluxInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.springframework.web.reactive.function.server.support.HandlerFunctionAdapter").or(ElementMatchers.named("org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter")).or(ElementMatchers.named("org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter")).or(ElementMatchers.named("org.springframework.web.reactive.result.SimpleHandlerAdapter"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handle").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.springframework.web.server.ServerWebExchange"))).and(ElementMatchers.takesArgument(1, Object.class));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.springwebflux.HandlerAdapterInstrumentation$HandleAdvice";
    }

    public static class HandleAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.Argument(value=0) ServerWebExchange exchange, @Advice.Argument(value=1) Object handler) {
            Object exchangeTransaction = exchange.getAttribute(WebfluxHelper.TRANSACTION_ATTRIBUTE);
            if (exchangeTransaction instanceof Transaction && handler instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                TransactionNameUtils.setNameFromClassAndMethod(handlerMethod.getBeanType().getSimpleName(), handlerMethod.getMethod().getName(), ((Transaction)exchangeTransaction).getAndOverrideName(100, false));
            }
            return exchangeTransaction;
        }

        @Nullable
        @Advice.AssignReturned.ToReturned
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static Mono<HandlerResult> onExit(@Advice.Argument(value=0) ServerWebExchange exchange, @Advice.Thrown @Nullable Throwable thrown, @Advice.Enter @Nullable Object enterTransaction, @Advice.Return @Nullable Mono<HandlerResult> resultMono) {
            if (!(enterTransaction instanceof Transaction) || resultMono == null) {
                return resultMono;
            }
            Transaction transaction = (Transaction)enterTransaction;
            transaction.captureException(thrown);
            if (transaction.isNoop()) {
                transaction.deactivate();
            }
            return resultMono;
        }
    }
}

