/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebclient;

import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import javax.annotation.Nullable;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.CoreSubscriber;

public class WebClientSubscriber<T>
implements CoreSubscriber<T>,
Subscription {
    private static final Logger logger = LoggerFactory.getLogger(WebClientSubscriber.class);
    private static final WeakMap<WebClientSubscriber<?>, Span> spanMap = WeakConcurrentProviderImpl.createWeakSpanMap();
    private final Tracer tracer;
    private final CoreSubscriber<? super T> subscriber;
    private Subscription subscription;

    public WebClientSubscriber(CoreSubscriber<? super T> subscriber, Span span, Tracer tracer) {
        this.subscriber = subscriber;
        this.tracer = tracer;
        spanMap.put(this, span);
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        Span span = this.getSpan();
        boolean hasActivated = this.doEnter("onSubscribe", span);
        Throwable thrown = null;
        try {
            this.subscriber.onSubscribe((Subscription)this);
            this.doExit(hasActivated, "onSubscribe", span);
            this.discardIf(thrown != null);
        }
        catch (Throwable e) {
            try {
                thrown = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.doExit(hasActivated, "onSubscribe", span);
                this.discardIf(thrown != null);
                throw throwable;
            }
        }
    }

    public void onNext(T t) {
        Span span = this.getSpan();
        boolean hasActivated = this.doEnter("onNext", span);
        Throwable thrown = null;
        try {
            if (span != null && t instanceof ClientResponse) {
                ClientResponse clientResponse = (ClientResponse)t;
                int statusCode = clientResponse.rawStatusCode();
                span.withOutcome(ResultUtil.getOutcomeByHttpClientStatus(statusCode));
                span.getContext().getHttp().withStatusCode(statusCode);
            }
            this.subscriber.onNext(t);
            this.doExit(hasActivated, "onNext", span);
            this.discardIf(thrown != null);
        }
        catch (Throwable e) {
            try {
                thrown = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.doExit(hasActivated, "onNext", span);
                this.discardIf(thrown != null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable throwable) {
        Span span = this.getSpan();
        boolean hasActivated = this.doEnter("onError", span);
        try {
            this.subscriber.onError(throwable);
        }
        finally {
            this.doExit(hasActivated, "onError", span);
            this.discardIf(true);
            this.endSpan(throwable, span);
        }
    }

    public void onComplete() {
        Span span = this.getSpan();
        boolean hasActivated = this.doEnter("onComplete", span);
        try {
            this.subscriber.onComplete();
        }
        finally {
            this.doExit(hasActivated, "onComplete", span);
            this.discardIf(true);
            this.endSpan(null, span);
        }
    }

    public void request(long n) {
        this.subscription.request(n);
    }

    public void cancel() {
        this.subscription.cancel();
        this.cancelSpan();
    }

    @Nullable
    private Span getSpan() {
        return spanMap.get(this);
    }

    private void discardIf(boolean condition) {
        if (!condition) {
            return;
        }
        spanMap.remove(this);
    }

    private boolean doEnter(String method, @Nullable Span span) {
        this.debugTrace(true, method, span);
        if (span == null || this.tracer.getActive() == span) {
            return false;
        }
        span.activate();
        return true;
    }

    private void doExit(boolean deactivate, String method, @Nullable Span span) {
        this.debugTrace(false, method, span);
        if (span == null || !deactivate) {
            return;
        }
        if (span != this.tracer.getActive()) {
            return;
        }
        span.deactivate();
    }

    private void debugTrace(boolean isEnter, String method, @Nullable Span span) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("{} webclient {} {}", isEnter ? ">>" : "<<", method, span);
    }

    private void endSpan(@Nullable Throwable thrown, @Nullable Span span) {
        if (span == null) {
            return;
        }
        ((Span)span.captureException(thrown)).end();
    }

    private void cancelSpan() {
        Span span = this.getSpan();
        this.debugTrace(true, "cancelSpan", span);
        try {
            if (span != null) {
                this.endSpan(null, span);
                spanMap.remove(this);
            }
        }
        finally {
            this.debugTrace(false, "cancelSpan", span);
        }
    }
}

