/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebclient;

import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.springwebclient.WebClientSubscriber;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

public class WebClientHelper {
    private static final Logger log = LoggerFactory.getLogger(WebClientHelper.class);

    public static <T> Publisher<T> wrapSubscriber(Publisher<T> publisher, final Span span, final Tracer tracer) {
        Function lift = Operators.liftPublisher((BiFunction)new BiFunction<Publisher, CoreSubscriber<? super T>, CoreSubscriber<? super T>>(){

            @Override
            public CoreSubscriber<? super T> apply(Publisher publisher, CoreSubscriber<? super T> subscriber) {
                log.trace("Trying to subscribe with span {}", (Object)span);
                if (tracer.getActive() == null) {
                    return subscriber;
                }
                return new WebClientSubscriber(subscriber, span, tracer);
            }
        });
        if (publisher instanceof Mono) {
            publisher = ((Mono)publisher).transform(lift);
        } else if (publisher instanceof Flux) {
            publisher = ((Flux)publisher).transform(lift);
        }
        return publisher;
    }
}

