/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.springwebclient.WebClientHelper;
import co.elastic.apm.agent.springwebclient.WebClientRequestHeaderSetter;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.function.client.ClientRequest;

public class WebClientExchangeFunctionInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("ExchangeFunction");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.reactive.function.client.ExchangeFunction")).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("exchange").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.springframework.web.reactive.function.client.ClientRequest")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "spring-webclient");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(index=0, value=0, typing=Assigner.Typing.DYNAMIC)})
        public static Object[] onBefore(@Advice.Argument(value=0) ClientRequest clientRequest) {
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null) {
                return null;
            }
            ClientRequest.Builder builder = ClientRequest.from((ClientRequest)clientRequest);
            URI uri = clientRequest.url();
            Span span = HttpClientHelper.startHttpClientSpan(parent, clientRequest.method().name(), uri, uri.getHost());
            if (span != null) {
                span.activate();
                span.propagateTraceContext(builder, WebClientRequestHeaderSetter.INSTANCE);
            } else {
                parent.propagateTraceContext(builder, WebClientRequestHeaderSetter.INSTANCE);
            }
            clientRequest = builder.build();
            return new Object[]{clientRequest, span};
        }

        @Advice.AssignReturned.ToReturned(typing=Assigner.Typing.DYNAMIC)
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static Object afterExecute(@Advice.Return @Nullable Publisher<?> returnValue, @Advice.Enter @Nullable Object[] spanRequestObj, @Advice.Thrown @Nullable Throwable t) {
            if (spanRequestObj == null || spanRequestObj.length < 2) {
                return returnValue;
            }
            Object spanObj = spanRequestObj[1];
            if (!(spanObj instanceof Span)) {
                return returnValue;
            }
            Span span = (Span)spanObj;
            span = (Span)((Span)span.captureException(t)).deactivate();
            if (t != null || returnValue == null) {
                return returnValue;
            }
            return WebClientHelper.wrapSubscriber(returnValue, span, TracerAwareInstrumentation.tracer);
        }
    }
}

