/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.servicename;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.servlet.AbstractServletInstrumentation;
import co.elastic.apm.agent.servlet.Constants;
import co.elastic.apm.agent.servlet.ServletServiceNameHelper;
import co.elastic.apm.agent.servlet.adapter.JakartaServletApiAdapter;
import co.elastic.apm.agent.servlet.adapter.JavaxServletApiAdapter;
import jakarta.servlet.ServletContext;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextEvent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class InitServiceNameInstrumentation
extends AbstractServletInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("servlet-api", "servlet-service-name");
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Filter").or(ElementMatchers.nameContains("Servlet")).or(ElementMatchers.nameContains("Listener"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.namedOneOf("javax.servlet.ServletContextListener", "javax.servlet.Filter", "javax.servlet.Servlet", "jakarta.servlet.ServletContextListener", "jakarta.servlet.Filter", "jakarta.servlet.Servlet")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("init").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.nameEndsWith("Config"))).or(ElementMatchers.named("contextInitialized").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.nameEndsWith("ServletContextEvent"))));
    }

    public static class JakartaInitServiceNameInstrumentation
    extends InitServiceNameInstrumentation {
        private static final Logger logger = LoggerFactory.getLogger(JakartaInitServiceNameInstrumentation.class);

        @Override
        public Constants.ServletImpl getImplConstants() {
            return Constants.ServletImpl.JAKARTA;
        }

        public static class AdviceClass {
            private static final JakartaServletApiAdapter adapter = JakartaServletApiAdapter.get();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.Argument(value=0) @Nullable Object arg) {
                ServletContext servletContext = null;
                try {
                    if (arg instanceof jakarta.servlet.FilterConfig) {
                        servletContext = adapter.getServletContextFromFilterConfig((jakarta.servlet.FilterConfig)arg);
                    } else if (arg instanceof jakarta.servlet.ServletConfig) {
                        servletContext = adapter.getServletContextFromServletConfig((jakarta.servlet.ServletConfig)arg);
                    } else if (arg instanceof jakarta.servlet.ServletContextEvent) {
                        servletContext = adapter.getServletContextFromServletContextEvent((jakarta.servlet.ServletContextEvent)arg);
                    }
                }
                catch (Exception e) {
                    String message = String.format("Failed obtain ServletContext from config %s. Stack trace printed in debug level", arg);
                    if (logger.isDebugEnabled()) {
                        logger.debug(message, e);
                    }
                    logger.info(message);
                }
                ServletServiceNameHelper.determineServiceName(adapter, servletContext, TracerAwareInstrumentation.tracer);
            }
        }
    }

    public static class JavaxInitServiceNameInstrumentation
    extends InitServiceNameInstrumentation {
        private static final Logger logger = LoggerFactory.getLogger(JavaxInitServiceNameInstrumentation.class);

        @Override
        public Constants.ServletImpl getImplConstants() {
            return Constants.ServletImpl.JAVAX;
        }

        public static class AdviceClass {
            private static final JavaxServletApiAdapter adapter = JavaxServletApiAdapter.get();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.Argument(value=0) @Nullable Object arg) {
                javax.servlet.ServletContext servletContext = null;
                try {
                    if (arg instanceof FilterConfig) {
                        servletContext = adapter.getServletContextFromFilterConfig((FilterConfig)arg);
                    } else if (arg instanceof ServletConfig) {
                        servletContext = adapter.getServletContextFromServletConfig((ServletConfig)arg);
                    } else if (arg instanceof ServletContextEvent) {
                        servletContext = adapter.getServletContextFromServletContextEvent((ServletContextEvent)arg);
                    }
                }
                catch (Exception e) {
                    String message = String.format("Failed obtain ServletContext from config %s. Stack trace printed in debug level", arg);
                    if (logger.isDebugEnabled()) {
                        logger.debug(message, e);
                    }
                    logger.info(message);
                }
                ServletServiceNameHelper.determineServiceName(adapter, servletContext, TracerAwareInstrumentation.tracer);
            }
        }
    }
}

