/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.helper;

import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.util.IOUtils;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public class JakartaRecordingServletInputStreamWrapper
extends ServletInputStream {
    private final Request request;
    private final ServletInputStream servletInputStream;

    public JakartaRecordingServletInputStreamWrapper(Request request, ServletInputStream servletInputStream) {
        this.request = request;
        this.servletInputStream = servletInputStream;
    }

    public int read() throws IOException {
        try {
            int b = this.servletInputStream.read();
            this.decode(b);
            return b;
        }
        catch (IOException e) {
            this.request.endOfBufferInput();
            throw e;
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            int read = this.servletInputStream.read(b);
            this.decode(b, 0, read);
            return read;
        }
        catch (IOException e) {
            this.request.endOfBufferInput();
            throw e;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.servletInputStream.read(b, off, len);
            this.decode(b, off, read);
            return read;
        }
        catch (IOException e) {
            this.request.endOfBufferInput();
            throw e;
        }
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.servletInputStream.readLine(b, off, len);
            this.decode(b, off, read);
            return read;
        }
        catch (IOException e) {
            this.request.endOfBufferInput();
            throw e;
        }
    }

    public byte[] readAllBytes() throws IOException {
        try {
            byte[] bytes = this.servletInputStream.readAllBytes();
            this.decode(bytes, 0, bytes.length);
            return bytes;
        }
        catch (IOException e) {
            this.request.endOfBufferInput();
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.servletInputStream.close();
        }
        finally {
            this.request.endOfBufferInput();
        }
    }

    public long skip(long n) throws IOException {
        return this.servletInputStream.skip(n);
    }

    public int available() throws IOException {
        return this.servletInputStream.available();
    }

    public void mark(int readlimit) {
        this.servletInputStream.mark(readlimit);
    }

    public void reset() throws IOException {
        try {
            this.servletInputStream.reset();
        }
        finally {
            this.request.endOfBufferInput();
        }
    }

    public boolean markSupported() {
        return this.servletInputStream.markSupported();
    }

    public boolean isFinished() {
        return this.servletInputStream.isFinished();
    }

    public boolean isReady() {
        return this.servletInputStream.isReady();
    }

    public void setReadListener(ReadListener readListener) {
        this.servletInputStream.setReadListener(readListener);
    }

    private void decode(byte[] b, int off, int read) {
        if (read == -1) {
            this.request.endOfBufferInput();
        } else {
            CharBuffer bodyBuffer = this.request.getBodyBuffer();
            if (bodyBuffer != null) {
                CoderResult coderResult = IOUtils.decodeUtf8Bytes(b, off, read, bodyBuffer);
                this.handleCoderResult(coderResult);
            }
        }
    }

    private void decode(int b) {
        if (b == -1) {
            this.request.endOfBufferInput();
        } else {
            CharBuffer bodyBuffer = this.request.getBodyBuffer();
            if (bodyBuffer != null) {
                CoderResult coderResult = IOUtils.decodeUtf8Byte((byte)b, bodyBuffer);
                this.handleCoderResult(coderResult);
            }
        }
    }

    private void handleCoderResult(CoderResult coderResult) {
        if (coderResult.isError()) {
            this.request.setRawBody("[Non UTF-8 data]");
        } else if (coderResult.isOverflow()) {
            this.request.endOfBufferInput();
        }
    }
}

