/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.helper;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.servlet.ServletTransactionHelper;
import co.elastic.apm.agent.servlet.helper.AsyncConstants;
import co.elastic.apm.agent.servlet.helper.AsyncContextAdviceHelper;
import co.elastic.apm.agent.servlet.helper.JakartaApmAsyncListener;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;

public class JakartaAsyncContextAdviceHelper
implements AsyncContextAdviceHelper<AsyncContext> {
    private final ObjectPool<JakartaApmAsyncListener> asyncListenerObjectPool;
    private final ServletTransactionHelper servletTransactionHelper;
    private final Tracer tracer;

    public JakartaAsyncContextAdviceHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.servletTransactionHelper = new ServletTransactionHelper(tracer);
        this.asyncListenerObjectPool = tracer.getObjectPoolFactory().createRecyclableObjectPool(256, new JakartaApmAsyncListenerAllocator());
    }

    ServletTransactionHelper getServletTransactionHelper() {
        return this.servletTransactionHelper;
    }

    @Override
    public void onExitStartAsync(AsyncContext asyncContext) {
        ServletRequest request = asyncContext.getRequest();
        if (request.getAttribute(AsyncConstants.ASYNC_LISTENER_ADDED) != null) {
            return;
        }
        Transaction transaction = this.tracer.currentTransaction();
        if (transaction != null && transaction.isSampled() && request.getAttribute(AsyncConstants.ASYNC_LISTENER_ADDED) == null) {
            request.setAttribute(AsyncConstants.ASYNC_LISTENER_ADDED, (Object)Boolean.TRUE);
            asyncContext.addListener((AsyncListener)this.asyncListenerObjectPool.createInstance().withTransaction(transaction), asyncContext.getRequest(), asyncContext.getResponse());
            request.setAttribute(ServletTransactionHelper.ASYNC_ATTRIBUTE, (Object)Boolean.TRUE);
            request.setAttribute(ServletTransactionHelper.TRANSACTION_ATTRIBUTE, (Object)transaction);
        }
    }

    void recycle(JakartaApmAsyncListener apmAsyncListener) {
        this.asyncListenerObjectPool.recycle(apmAsyncListener);
    }

    private final class JakartaApmAsyncListenerAllocator
    implements Allocator<JakartaApmAsyncListener> {
        private JakartaApmAsyncListenerAllocator() {
        }

        @Override
        public JakartaApmAsyncListener createInstance() {
            return new JakartaApmAsyncListener(JakartaAsyncContextAdviceHelper.this);
        }
    }
}

