/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.servlet.AbstractServletInstrumentation;
import co.elastic.apm.agent.util.LoggerUtils;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ServletVersionInstrumentation
extends AbstractServletInstrumentation {
    private static final Logger logger = LoggerUtils.logOnce(LoggerFactory.getLogger(ServletVersionInstrumentation.class));

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("servlet-api", "servlet-version");
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Servlet").or(ElementMatchers.nameContainsIgnoreCase("jsp"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(this.getImplConstants().servletClass()));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.any();
    }

    public static void logServletVersion(@Nullable Object[] infoFromServletContext) {
        if (infoFromServletContext == null || !logger.isWarnEnabled() || !logger.isInfoEnabled()) {
            return;
        }
        int majorVersion = -1;
        int minorVersion = -1;
        String serverInfo = null;
        if (infoFromServletContext.length > 2) {
            if (infoFromServletContext[0] != null) {
                majorVersion = (Integer)infoFromServletContext[0];
            }
            if (infoFromServletContext[1] != null) {
                minorVersion = (Integer)infoFromServletContext[1];
            }
            if (infoFromServletContext[2] instanceof String) {
                serverInfo = (String)infoFromServletContext[2];
            }
        }
        if (majorVersion < 3) {
            logger.warn("Unsupported servlet version detected: {}.{}, no Servlet transaction will be created. Servlet container info = {}", majorVersion, minorVersion, serverInfo);
        } else {
            logger.info("Servlet container info = {}", (Object)serverInfo);
        }
    }

    public static boolean isLogEnabled() {
        return logger.isInfoEnabled() || logger.isWarnEnabled();
    }

    public static abstract class Service
    extends ServletVersionInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("service").and(ElementMatchers.takesArgument(0, this.getImplConstants().requestClassMatcher())).and(ElementMatchers.takesArgument(1, this.getImplConstants().responseClassMatcher()));
        }
    }

    public static abstract class Init
    extends ServletVersionInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("init").and(ElementMatchers.takesArgument(0, this.getImplConstants().servletConfigClassMatcher()));
        }
    }
}

