/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import javax.annotation.Nullable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public final class JavaxUtil {
    private static final Logger logger = LoggerFactory.getLogger(JavaxUtil.class);

    private JavaxUtil() {
    }

    @Nullable
    public static Object[] getInfoFromServletContext(@Nullable ServletConfig servletConfig) {
        if (servletConfig != null) {
            try {
                ServletContext servletContext = servletConfig.getServletContext();
                if (null != servletContext) {
                    return new Object[]{servletContext.getMajorVersion(), servletContext.getMinorVersion(), servletContext.getServerInfo()};
                }
            }
            catch (Exception e) {
                String message = String.format("Failed obtain ServletContext from ServletConfig %s. Stack trace printed in debug level", servletConfig);
                if (logger.isDebugEnabled()) {
                    logger.debug(message, e);
                }
                logger.info(message);
            }
        }
        return null;
    }
}

