/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.servlet.Constants;
import co.elastic.apm.agent.servlet.JavaxUtil;
import co.elastic.apm.agent.servlet.ServletVersionInstrumentation;
import javax.annotation.Nullable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import net.bytebuddy.asm.Advice;

public abstract class JavaxServletVersionInstrumentation {

    public static class JavaxService
    extends ServletVersionInstrumentation.Service {
        @Override
        public Constants.ServletImpl getImplConstants() {
            return Constants.ServletImpl.JAVAX;
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.This Servlet servlet) {
                if (ServletVersionInstrumentation.isLogEnabled()) {
                    ServletVersionInstrumentation.logServletVersion(JavaxUtil.getInfoFromServletContext(servlet.getServletConfig()));
                }
            }
        }
    }

    public static class JavaxInit
    extends ServletVersionInstrumentation.Init {
        @Override
        public Constants.ServletImpl getImplConstants() {
            return Constants.ServletImpl.JAVAX;
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.Argument(value=0) @Nullable ServletConfig servletConfig) {
                if (ServletVersionInstrumentation.isLogEnabled()) {
                    ServletVersionInstrumentation.logServletVersion(JavaxUtil.getInfoFromServletContext(servletConfig));
                }
            }
        }
    }
}

