/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.servlet.Constants;
import co.elastic.apm.agent.servlet.JakartaUtil;
import co.elastic.apm.agent.servlet.ServletVersionInstrumentation;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;

public abstract class JakartaServletVersionInstrumentation {

    public static class JakartaService
    extends ServletVersionInstrumentation.Service {
        @Override
        public Constants.ServletImpl getImplConstants() {
            return Constants.ServletImpl.JAKARTA;
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.This Servlet servlet) {
                if (ServletVersionInstrumentation.isLogEnabled()) {
                    ServletVersionInstrumentation.logServletVersion(JakartaUtil.getInfoFromServletContext(servlet.getServletConfig()));
                }
            }
        }
    }

    public static class JakartaInit
    extends ServletVersionInstrumentation.Init {
        @Override
        public Constants.ServletImpl getImplConstants() {
            return Constants.ServletImpl.JAKARTA;
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.Argument(value=0) @Nullable ServletConfig servletConfig) {
                if (ServletVersionInstrumentation.isLogEnabled()) {
                    ServletVersionInstrumentation.logServletVersion(JakartaUtil.getInfoFromServletContext(servletConfig));
                }
            }
        }
    }
}

