/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class Constants {
    public static final String SERVLET_API = "servlet-api";
    static final String SERVLET_API_DISPATCH = "servlet-api-dispatch";
    static final String SERVLET_API_ASYNC = "servlet-api-async";
    static final String SERVLET_INPUT_STREAM = "servlet-input-stream";

    private Constants() {
    }

    public static enum ServletImpl {
        JAVAX("javax.servlet.Servlet", "javax.servlet.Filter", "javax.servlet.ServletRequest", "javax.servlet.ServletResponse", "javax.servlet.FilterChain", "javax.servlet.AsyncContext", "javax.servlet.http.HttpServlet", "javax.servlet.ServletInputStream", "javax.servlet.ServletConfig"),
        JAKARTA("jakarta.servlet.Servlet", "jakarta.servlet.Filter", "jakarta.servlet.ServletRequest", "jakarta.servlet.ServletResponse", "jakarta.servlet.FilterChain", "jakarta.servlet.AsyncContext", "jakarta.servlet.http.HttpServlet", "jakarta.servlet.ServletInputStream", "jakarta.servlet.ServletConfig");

        private final String servletClass;
        private final String filterClass;
        private final String requestClass;
        private final String responseClass;
        private final String filterChainClass;
        private final String servletInputStreamClass;
        private final String servletConfigClass;
        private final String asyncContextClass;
        private final String osgiClassloaderFilterClass;

        private ServletImpl(String servletClass, String filterClass, String requestClass, String responseClass, String filterChainClass, String asyncContextClass, String osgiClassloaderFilterClass, String servletInputStreamClass, String servletConfigClass) {
            this.servletClass = servletClass;
            this.filterClass = filterClass;
            this.requestClass = requestClass;
            this.responseClass = responseClass;
            this.filterChainClass = filterChainClass;
            this.asyncContextClass = asyncContextClass;
            this.osgiClassloaderFilterClass = osgiClassloaderFilterClass;
            this.servletInputStreamClass = servletInputStreamClass;
            this.servletConfigClass = servletConfigClass;
        }

        public ElementMatcher.Junction<NamedElement> servletClass() {
            return ElementMatchers.named(this.servletClass);
        }

        public ElementMatcher.Junction<NamedElement> filterClass() {
            return ElementMatchers.named(this.filterClass);
        }

        public ElementMatcher.Junction<NamedElement> requestClassMatcher() {
            return ElementMatchers.named(this.requestClass);
        }

        public ElementMatcher.Junction<NamedElement> responseClassMatcher() {
            return ElementMatchers.named(this.responseClass);
        }

        public ElementMatcher.Junction<NamedElement> filterChainClassMatcher() {
            return ElementMatchers.named(this.filterChainClass);
        }

        public ElementMatcher.Junction<NamedElement> asyncContextClassMatcher() {
            return ElementMatchers.named(this.asyncContextClass);
        }

        public ElementMatcher.Junction<TypeDescription> servletInputStreamClassMatcher() {
            return ElementMatchers.named(this.servletInputStreamClass);
        }

        public ElementMatcher.Junction<TypeDescription> servletConfigClassMatcher() {
            return ElementMatchers.named(this.servletConfigClass);
        }

        public ElementMatcher.Junction<ClassLoader> getClassloaderFilterMatcher() {
            return CustomElementMatchers.classLoaderCanLoadClass(this.asyncContextClass).and(CustomElementMatchers.classLoaderCanLoadClass(this.osgiClassloaderFilterClass));
        }
    }
}

