/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.report.ReportingEvent;
import java.util.concurrent.atomic.AtomicLongArray;

public class ReportingEventCounter {
    private final AtomicLongArray counters;

    public ReportingEventCounter() {
        ReportingEvent.ReportingEventType[] types = ReportingEvent.ReportingEventType.values();
        this.counters = new AtomicLongArray(types.length);
    }

    public ReportingEventCounter(ReportingEventCounter toCopy) {
        this();
        for (int i = 0; i < this.counters.length(); ++i) {
            this.counters.set(i, toCopy.counters.get(i));
        }
    }

    public void reset() {
        for (int i = 0; i < this.counters.length(); ++i) {
            this.counters.set(i, 0L);
        }
    }

    public void increment(ReportingEvent.ReportingEventType type) {
        this.counters.incrementAndGet(type.ordinal());
    }

    public void add(ReportingEvent.ReportingEventType type, long count) {
        this.counters.addAndGet(type.ordinal(), count);
    }

    public long getCount(ReportingEvent.ReportingEventType type) {
        return this.counters.get(type.ordinal());
    }

    public long getTotalCount() {
        long sum = 0L;
        for (int i = 0; i < this.counters.length(); ++i) {
            sum += this.counters.get(i);
        }
        return sum;
    }

    public void addAll(ReportingEventCounter other) {
        for (int i = 0; i < this.counters.length(); ++i) {
            this.counters.addAndGet(i, other.counters.get(i));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReportingEventCounter[");
        boolean isFirst = true;
        for (ReportingEvent.ReportingEventType type : ReportingEvent.ReportingEventType.values()) {
            long count = this.getCount(type);
            if (count <= 0L) continue;
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(type.toString()).append('=').append(count);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportingEventCounter that = (ReportingEventCounter)o;
        for (int i = 0; i < this.counters.length(); ++i) {
            if (this.counters.get(i) == that.counters.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.counters.length(); ++i) {
            long element = this.counters.get(i);
            int elementHash = (int)(element ^ element >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }
}

