/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.impl.metadata.MetaData;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.ApmServerReporter;
import co.elastic.apm.agent.report.IntakeV2ReportingEventHandler;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ReporterMonitor;
import co.elastic.apm.agent.report.ReportingEventHandler;
import co.elastic.apm.agent.report.processor.ProcessorEventHandler;
import co.elastic.apm.agent.report.serialize.DslJsonSerializer;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.stagemonitor.configuration.ConfigurationRegistry;

public class ReporterFactory {
    public Reporter createReporter(ConfigurationRegistry configurationRegistry, ApmServerClient apmServerClient, Future<MetaData> metaData, ReporterMonitor monitor) {
        ReporterConfiguration reporterConfiguration = configurationRegistry.getConfig(ReporterConfiguration.class);
        ReportingEventHandler reportingEventHandler = this.getReportingEventHandler(configurationRegistry, reporterConfiguration, metaData, apmServerClient);
        return new ApmServerReporter(true, reporterConfiguration, reportingEventHandler, monitor);
    }

    @Nonnull
    private ReportingEventHandler getReportingEventHandler(ConfigurationRegistry configurationRegistry, ReporterConfiguration reporterConfiguration, Future<MetaData> metaData, ApmServerClient apmServerClient) {
        DslJsonSerializer payloadSerializer = new DslJsonSerializer(configurationRegistry.getConfig(StacktraceConfiguration.class), apmServerClient, metaData);
        ProcessorEventHandler processorEventHandler = ProcessorEventHandler.loadProcessors(configurationRegistry);
        return new IntakeV2ReportingEventHandler(reporterConfiguration, processorEventHandler, payloadSerializer, apmServerClient);
    }
}

