/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

class CountingOutputStream
extends OutputStream {
    private final OutputStream out;
    private long count;

    CountingOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void write(@Nonnull byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += (long)len;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public long getCount() {
        return this.count;
    }
}

