/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.report.ApmServerHealthChecker;
import co.elastic.apm.agent.report.HttpUtils;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ssl.SslUtils;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.UrlConnectionUtils;
import co.elastic.apm.agent.util.Version;
import co.elastic.apm.agent.util.VersionUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.stagemonitor.configuration.ConfigurationOption;

public class ApmServerClient {
    private static final Logger logger = LoggerFactory.getLogger(ApmServerClient.class);
    private static final Version VERSION_6_7 = Version.of("6.7.0");
    private static final Version VERSION_7_0 = Version.of("7.0.0");
    private static final Version VERSION_7_4 = Version.of("7.4.0");
    private static final Version VERSION_7_9 = Version.of("7.9.0");
    private static final Version VERSION_8_0 = Version.of("8.0.0");
    private final ReporterConfiguration reporterConfiguration;
    @Nullable
    private volatile List<URL> serverUrls;
    @Nullable
    private volatile Future<Version> apmServerVersion;
    private final AtomicInteger errorCount = new AtomicInteger();
    private final ApmServerHealthChecker healthChecker;
    private final String userAgent;

    public ApmServerClient(ReporterConfiguration reporterConfiguration, CoreConfiguration coreConfiguration) {
        this.reporterConfiguration = reporterConfiguration;
        this.healthChecker = new ApmServerHealthChecker(this);
        this.userAgent = ApmServerClient.getUserAgent(coreConfiguration);
    }

    public void start() {
        this.start(ApmServerClient.shuffleUrls(this.reporterConfiguration.getServerUrls()));
    }

    public void start(List<URL> shuffledUrls) {
        this.reporterConfiguration.getServerUrlOption().addChangeListener(new ConfigurationOption.ChangeListener<URL>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, URL oldValue, URL newValue) {
                logger.debug("server_url overridden with value = ({}).", (Object)newValue);
                ApmServerClient.this.setServerUrls(ApmServerClient.this.reporterConfiguration.getServerUrls());
            }
        });
        this.reporterConfiguration.getServerUrlsOption().addChangeListener(new ConfigurationOption.ChangeListener<List<URL>>(){

            @Override
            public void onChange(ConfigurationOption<?> configurationOption, List<URL> oldValue, List<URL> newValue) {
                logger.debug("server_urls overridden with value = ({}).", (Object)newValue);
                ApmServerClient.this.setServerUrls(ApmServerClient.this.reporterConfiguration.getServerUrls());
            }
        });
        this.setServerUrls(Collections.unmodifiableList(shuffledUrls));
    }

    private void setServerUrls(List<URL> serverUrls) {
        this.serverUrls = serverUrls;
        this.apmServerVersion = this.healthChecker.checkHealthAndGetMinVersion();
        this.errorCount.set(0);
    }

    private static List<URL> shuffleUrls(List<URL> serverUrls) {
        ArrayList<URL> copy = new ArrayList<URL>(serverUrls);
        Collections.shuffle(copy);
        return copy;
    }

    @Nullable
    HttpURLConnection startRequest(String relativePath) throws IOException {
        URL url = this.appendPathToCurrentUrl(relativePath);
        if (url == null) {
            return null;
        }
        return this.startRequestToUrl(url);
    }

    @Nonnull
    private HttpURLConnection startRequestToUrl(URL url) throws IOException {
        URLConnection connection = UrlConnectionUtils.openUrlConnectionThreadSafely(url);
        if (connection instanceof HttpsURLConnection) {
            SSLSocketFactory sslSocketFactory;
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            boolean verifyServerCert = this.reporterConfiguration.isVerifyServerCert();
            if (!verifyServerCert) {
                httpsConnection.setHostnameVerifier(SslUtils.getTrustAllHostnameVerifier());
            }
            if ((sslSocketFactory = SslUtils.getSSLSocketFactory(verifyServerCert)) != null) {
                httpsConnection.setSSLSocketFactory(sslSocketFactory);
            }
        }
        String secretToken = this.reporterConfiguration.getSecretToken();
        String apiKey = this.reporterConfiguration.getApiKey();
        String authHeaderValue = null;
        if (apiKey != null) {
            authHeaderValue = String.format("ApiKey %s", apiKey);
        } else if (secretToken != null) {
            authHeaderValue = String.format("Bearer %s", secretToken);
        }
        if (authHeaderValue != null) {
            connection.setRequestProperty("Authorization", authHeaderValue);
        }
        connection.setRequestProperty("User-Agent", this.userAgent);
        connection.setConnectTimeout((int)this.reporterConfiguration.getServerTimeout().getMillis());
        connection.setReadTimeout((int)this.reporterConfiguration.getServerTimeout().getMillis());
        return (HttpURLConnection)connection;
    }

    @Nullable
    URL appendPathToCurrentUrl(String apmServerPath) throws MalformedURLException {
        URL currentUrl = this.getCurrentUrl();
        if (currentUrl == null) {
            return null;
        }
        return this.appendPath(currentUrl, apmServerPath);
    }

    @Nonnull
    private URL appendPath(URL serverUrl, String apmServerPath) throws MalformedURLException {
        String path = serverUrl.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return new URL(serverUrl, path + apmServerPath);
    }

    int incrementAndGetErrorCount(int expectedErrorCount) {
        boolean success = this.errorCount.compareAndSet(expectedErrorCount, expectedErrorCount + 1);
        if (success) {
            return expectedErrorCount + 1;
        }
        return -1;
    }

    void onConnectionError() {
        this.errorCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V execute(String path, ConnectionHandler<V> connectionHandler) throws Exception {
        List<URL> prioritizedUrlList = this.getPrioritizedUrlList();
        if (prioritizedUrlList.isEmpty()) {
            return null;
        }
        int expectedErrorCount = this.errorCount.get();
        Exception previousException = null;
        for (URL serverUrl : prioritizedUrlList) {
            V v;
            HttpURLConnection connection = null;
            try {
                connection = this.startRequestToUrl(this.appendPath(serverUrl, path));
                v = connectionHandler.withConnection(connection);
            }
            catch (Exception e) {
                try {
                    expectedErrorCount = this.incrementAndGetErrorCount(expectedErrorCount);
                    logger.debug("Exception while interacting with APM Server, trying next one.");
                    if (previousException != null) {
                        e.addSuppressed(previousException);
                    }
                    previousException = e;
                }
                catch (Throwable throwable) {
                    HttpUtils.consumeAndClose(connection);
                    throw throwable;
                }
                HttpUtils.consumeAndClose(connection);
                continue;
            }
            HttpUtils.consumeAndClose(connection);
            return v;
        }
        if (previousException == null) {
            throw new IllegalStateException("Expected previousException not to be null");
        }
        throw previousException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeForAllUrls(String path, ConnectionHandler<T> connectionHandler) {
        List<URL> serverUrls = this.getServerUrls();
        ArrayList<T> results = new ArrayList<T>(serverUrls.size());
        for (URL serverUrl : serverUrls) {
            HttpURLConnection connection = null;
            try {
                connection = this.startRequestToUrl(this.appendPath(serverUrl, path));
                results.add(connectionHandler.withConnection(connection));
            }
            catch (Exception e) {
                try {
                    logger.debug("Exception while interacting with APM Server", e);
                }
                catch (Throwable throwable) {
                    HttpUtils.consumeAndClose(connection);
                    throw throwable;
                }
                HttpUtils.consumeAndClose(connection);
                continue;
            }
            HttpUtils.consumeAndClose(connection);
        }
        return results;
    }

    @Nullable
    URL getCurrentUrl() {
        List<URL> serverUrls = this.getServerUrls();
        if (serverUrls.isEmpty()) {
            return null;
        }
        return serverUrls.get(this.errorCount.get() % serverUrls.size());
    }

    @Nonnull
    private List<URL> getPrioritizedUrlList() {
        ArrayList<URL> serverUrlsCopy = new ArrayList<URL>(this.getServerUrls());
        Collections.rotate(serverUrlsCopy, this.errorCount.get());
        return serverUrlsCopy;
    }

    int getErrorCount() {
        return this.errorCount.get();
    }

    List<URL> getServerUrls() {
        if (this.serverUrls == null) {
            throw new IllegalStateException("APM Server client not yet initialized");
        }
        return this.serverUrls;
    }

    public boolean supportsNonStringLabels() {
        return this.isAtLeast(VERSION_6_7);
    }

    public boolean supportsNumericUrlPort() {
        return this.isAtLeast(VERSION_7_0);
    }

    public boolean supportsMultipleHeaderValues() {
        return this.isAtLeast(VERSION_7_0);
    }

    public boolean supportsConfiguredAndDetectedHostname() {
        return this.isAtLeast(VERSION_7_4);
    }

    public boolean supportsLogsEndpoint() {
        return this.isAtLeast(VERSION_7_9);
    }

    public boolean supportsKeepingUnsampledTransaction() {
        if (this.apmServerVersion != null && !this.apmServerVersion.isDone()) {
            return true;
        }
        return this.isLowerThan(VERSION_8_0);
    }

    @Nullable
    Version getApmServerVersion(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.apmServerVersion != null) {
            return this.apmServerVersion.get(timeout, timeUnit);
        }
        return null;
    }

    public boolean isLowerThan(Version apmServerVersion) {
        return !this.isAtLeast(apmServerVersion);
    }

    public boolean isAtLeast(Version apmServerVersion) {
        if (this.apmServerVersion == null) {
            throw new IllegalStateException("Called before init event");
        }
        try {
            Version localApmServerVersion = this.apmServerVersion.get();
            if (localApmServerVersion == null) {
                return false;
            }
            return localApmServerVersion.compareTo(apmServerVersion) >= 0;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            return false;
        }
    }

    private static String getUserAgent(CoreConfiguration coreConfiguration) {
        StringBuilder userAgent = new StringBuilder();
        userAgent.append("apm-agent-java/").append(VersionUtils.getAgentVersion());
        String serviceName = coreConfiguration.getServiceName();
        String serviceVersion = coreConfiguration.getServiceVersion();
        if (!serviceName.isEmpty()) {
            userAgent.append(" (").append(serviceName);
            if (serviceVersion != null && !serviceVersion.isEmpty()) {
                userAgent.append(" ").append(ApmServerClient.escapeHeaderComment(serviceVersion));
            }
            userAgent.append(")");
        }
        return userAgent.toString();
    }

    static String escapeHeaderComment(String headerFieldComment) {
        return headerFieldComment.replaceAll("[^\\t \\x21-\\x27\\x2a-\\x5b\\x5d-\\x7e\\x80-\\xff]", "_");
    }

    public static interface ConnectionHandler<T> {
        @Nullable
        public T withConnection(HttpURLConnection var1) throws IOException;
    }
}

