/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.rabbitmq.MessageBatchHelper;
import co.elastic.apm.agent.rabbitmq.SpringBaseInstrumentation;
import co.elastic.apm.agent.rabbitmq.header.SpringRabbitMQTextHeaderGetter;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.LoggerUtils;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

public class SpringAmqpBatchMessageListenerInstrumentation
extends SpringBaseInstrumentation {
    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("onMessageBatch").and(ElementMatchers.takesArgument(0, List.class)).and(ElementMatchers.isPublic());
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.rabbitmq.SpringAmqpBatchMessageListenerInstrumentation$MessageListenerContainerWrappingAdvice";
    }

    public static class MessageListenerContainerWrappingAdvice
    extends SpringBaseInstrumentation.BaseAdvice {
        private static final Logger oneTimeTransactionCreationWarningLogger;
        private static final MessageBatchHelper messageBatchHelper;
        private static final MessagingConfiguration messagingConfiguration;

        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(index=0, value=0, typing=Assigner.Typing.DYNAMIC)})
        @Advice.OnMethodEnter(inline=false)
        public static Object[] beforeOnBatch(@Advice.This Object thiz, @Advice.Argument(value=0) @Nullable List<Message> messageBatch) {
            List<Message> processedBatch = messageBatch;
            Transaction batchTransaction = null;
            if (TracerAwareInstrumentation.tracer.isRunning() && messageBatch != null && !messageBatch.isEmpty()) {
                AbstractSpan<?> active = TracerAwareInstrumentation.tracer.getActive();
                if (active == null && messagingConfiguration.getMessageBatchStrategy() == MessagingConfiguration.BatchStrategy.BATCH_HANDLING) {
                    batchTransaction = TracerAwareInstrumentation.tracer.startRootTransaction(PrivilegedActionUtils.getClassLoader(thiz.getClass()));
                    if (batchTransaction == null) {
                        oneTimeTransactionCreationWarningLogger.warn("Failed to start Spring AMQP transaction for batch processing");
                    } else {
                        ((Transaction)((Transaction)batchTransaction.withType("messaging")).withName("Spring AMQP Message Batch Processing")).activate();
                    }
                } else {
                    oneTimeTransactionCreationWarningLogger.warn("Unexpected active span during batch message processing start: {}", (Object)active);
                }
                active = TracerAwareInstrumentation.tracer.getActive();
                if (active != null) {
                    for (Message message : messageBatch) {
                        MessageProperties messageProperties = message.getMessageProperties();
                        if (messageProperties == null) continue;
                        active.addSpanLink(TraceContext.getFromTraceContextTextHeaders(), SpringRabbitMQTextHeaderGetter.INSTANCE, messageProperties);
                    }
                } else {
                    processedBatch = messageBatchHelper.wrapMessageBatchList(messageBatch);
                }
            }
            return new Object[]{processedBatch, batchTransaction};
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void afterOnBatch(@Advice.Enter @Nullable Object[] enter, @Advice.Thrown @Nullable Throwable throwable) {
            Transaction batchTransaction;
            Transaction transaction = batchTransaction = enter != null ? (Transaction)enter[1] : null;
            if (batchTransaction != null) {
                try {
                    ((Transaction)batchTransaction.captureException(throwable)).end();
                }
                finally {
                    batchTransaction.deactivate();
                }
            }
        }

        static {
            ElasticApmTracer elasticApmTracer = GlobalTracer.requireTracerImpl();
            messageBatchHelper = new MessageBatchHelper(elasticApmTracer, transactionHelper);
            messagingConfiguration = elasticApmTracer.getConfig(MessagingConfiguration.class);
            oneTimeTransactionCreationWarningLogger = LoggerUtils.logOnce(LoggerFactory.getLogger("Spring-AMQP-Batch-Logger"));
        }
    }
}

