/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.rabbitmq.SpringAmqpTransactionNameUtil;
import com.rabbitmq.client.Channel;
import javax.annotation.Nullable;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;

public class MessageListenerHelper {
    @Nullable
    public MessageListener registerAndWrapLambda(@Nullable MessageListener listener) {
        if (listener != null) {
            if (listener.getClass().getName().contains("/")) {
                listener = listener instanceof ChannelAwareMessageListener ? new ChannelAwareMessageListenerWrapper((ChannelAwareMessageListener)listener) : new MessageListenerWrapper((MessageListener)listener);
            }
            SpringAmqpTransactionNameUtil.register(listener);
        }
        return listener;
    }

    public static class ChannelAwareMessageListenerWrapper
    implements ChannelAwareMessageListener {
        private final ChannelAwareMessageListener delegate;

        public ChannelAwareMessageListenerWrapper(ChannelAwareMessageListener delegate) {
            this.delegate = delegate;
        }

        public void onMessage(Message message, Channel channel) throws Exception {
            this.delegate.onMessage(message, channel);
        }

        public void onMessage(Message message) {
            this.delegate.onMessage(message);
        }
    }

    public static class MessageListenerWrapper
    implements MessageListener {
        private final MessageListener delegate;

        public MessageListenerWrapper(MessageListener delegate) {
            this.delegate = delegate;
        }

        public void onMessage(Message message) {
            this.delegate.onMessage(message);
        }
    }
}

