/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.rabbitmq.SpringAmqpTransactionHelper;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.Iterator;
import org.springframework.amqp.core.Message;

public class MessageBatchIteratorWrapper
implements Iterator<Message> {
    public static final Logger logger = LoggerFactory.getLogger(MessageBatchIteratorWrapper.class);
    private final Iterator<Message> delegate;
    private final ElasticApmTracer tracer;
    private final SpringAmqpTransactionHelper transactionHelper;

    public MessageBatchIteratorWrapper(Iterator<Message> delegate, ElasticApmTracer tracer, SpringAmqpTransactionHelper transactionHelper) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.transactionHelper = transactionHelper;
    }

    @Override
    public boolean hasNext() {
        this.endCurrentTransaction();
        return this.delegate.hasNext();
    }

    public void endCurrentTransaction() {
        try {
            Transaction transaction = this.tracer.currentTransaction();
            if (transaction != null && "messaging".equals(transaction.getType())) {
                ((Transaction)transaction.deactivate()).end();
            }
        }
        catch (Exception e) {
            logger.error("Error in Spring AMQP iterator wrapper", e);
        }
    }

    @Override
    public Message next() {
        this.endCurrentTransaction();
        Message message = this.delegate.next();
        try {
            this.transactionHelper.createTransaction(message, "Spring AMQP");
        }
        catch (Throwable throwable) {
            logger.error("Error in transaction creation based on Spring AMQP batch message", throwable);
        }
        return message;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

