/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.rabbitmq.AbstractBaseInstrumentation;
import co.elastic.apm.agent.rabbitmq.RabbitmqBaseInstrumentation;
import co.elastic.apm.agent.rabbitmq.header.RabbitMQTextHeaderGetter;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ConsumerInstrumentation
extends RabbitmqBaseInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.not(ElementMatchers.nameStartsWith("org.springframework."));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.any();
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handleDelivery");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("com.rabbitmq.client.Consumer"));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.rabbitmq.ConsumerInstrumentation$RabbitConsumerAdvice";
    }

    public static class RabbitConsumerAdvice {
        private RabbitConsumerAdvice() {
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onHandleDelivery(@Advice.Origin Class<?> originClazz, @Advice.This Consumer consumer, @Advice.Argument(value=1) @Nullable Envelope envelope, @Advice.Argument(value=2) @Nullable AMQP.BasicProperties properties) {
            String exchange;
            if (!TracerAwareInstrumentation.tracer.isRunning()) {
                return null;
            }
            String string = exchange = envelope != null ? envelope.getExchange() : null;
            if (null == exchange || AbstractBaseInstrumentation.isIgnored(exchange)) {
                return null;
            }
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction != null) {
                return null;
            }
            transaction = TracerAwareInstrumentation.tracer.startChildTransaction(properties, RabbitMQTextHeaderGetter.INSTANCE, PrivilegedActionUtils.getClassLoader(originClazz));
            if (transaction == null) {
                return null;
            }
            ((Transaction)((Transaction)transaction.withType("messaging")).withName("RabbitMQ RECEIVE from ")).appendToName(AbstractBaseInstrumentation.normalizeExchangeName(exchange));
            transaction.setFrameworkName("RabbitMQ");
            Message message = AbstractBaseInstrumentation.captureMessage(exchange, envelope.getRoutingKey(), AbstractBaseInstrumentation.getTimestamp(properties != null ? properties.getTimestamp() : null), transaction);
            if (properties != null) {
                AbstractBaseInstrumentation.captureHeaders(properties.getHeaders(), message);
            }
            return transaction.activate();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static void afterHandleDelivery(@Advice.Enter @Nullable Object transactionObject, @Advice.Thrown @Nullable Throwable throwable) {
            if (transactionObject instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObject;
                ((Transaction)((Transaction)transaction.captureException(throwable)).deactivate()).end();
            }
        }
    }
}

