/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.configuration.ServiceInfo;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.pluginapi.ApiInstrumentation;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class TransactionInstrumentation
extends ApiInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public TransactionInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.TransactionImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class UseServiceInfoForClassLoaderInstrumentation
    extends TransactionInstrumentation {
        public UseServiceInfoForClassLoaderInstrumentation() {
            super(ElementMatchers.named("useServiceInfoForClassLoader"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void useServiceInfoForClassLoader(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object transaction, @Advice.Argument(value=0) ClassLoader classLoader) {
                ServiceInfo serviceInfo;
                if (transaction instanceof Transaction && (serviceInfo = TracerAwareInstrumentation.tracer.getServiceInfoForClassLoader(classLoader)) != null) {
                    ((Transaction)transaction).getTraceContext().setServiceInfo(serviceInfo.getServiceName(), serviceInfo.getServiceVersion());
                }
            }
        }
    }

    public static class SetServiceInfoInstrumentation
    extends TransactionInstrumentation {
        public SetServiceInfoInstrumentation() {
            super(ElementMatchers.named("setServiceInfo"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setServiceInfo(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object transaction, @Advice.Argument(value=0) String serviceName, @Advice.Argument(value=1) String serviceVersion) {
                if (transaction instanceof Transaction) {
                    ((Transaction)transaction).getTraceContext().setServiceInfo(serviceName, serviceVersion);
                }
            }
        }
    }

    public static class AddCustomContextInstrumentation
    extends TransactionInstrumentation {
        public AddCustomContextInstrumentation() {
            super(ElementMatchers.named("addCustomContext"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void addCustomContext(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object transactionObj, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) @Nullable Object value) {
                if (value != null && transactionObj instanceof Transaction) {
                    Transaction transaction = (Transaction)transactionObj;
                    if (value instanceof String) {
                        transaction.addCustomContext(key, (String)value);
                    } else if (value instanceof Number) {
                        transaction.addCustomContext(key, (Number)value);
                    } else if (value instanceof Boolean) {
                        transaction.addCustomContext(key, (Boolean)value);
                    }
                }
            }
        }
    }

    public static class SetResultInstrumentation
    extends TransactionInstrumentation {
        public SetResultInstrumentation() {
            super(ElementMatchers.named("setResult"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setResult(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object transaction, @Advice.Argument(value=0) String result) {
                if (transaction instanceof Transaction) {
                    ((Transaction)transaction).withResult(result);
                }
            }
        }
    }

    public static class EnsureParentIdInstrumentation
    extends TransactionInstrumentation {
        public EnsureParentIdInstrumentation() {
            super(ElementMatchers.named("ensureParentId"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static String ensureParentId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object transaction, @Advice.Return @Nullable String returnValue) {
                if (transaction instanceof Transaction) {
                    TraceContext traceContext = ((Transaction)transaction).getTraceContext();
                    Id parentId = traceContext.getParentId();
                    if (parentId.isEmpty()) {
                        parentId.setToRandomValue();
                    }
                    return parentId.toString();
                }
                return returnValue;
            }
        }
    }

    public static class SetUserInstrumentation
    extends TransactionInstrumentation {
        public SetUserInstrumentation() {
            super(ElementMatchers.named("setUser"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setUser(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object transaction, @Advice.Argument(value=0) String id, @Advice.Argument(value=1) String email, @Advice.Argument(value=2) String username, @Advice.Argument(value=3, optional=true) String domain) {
                if (transaction instanceof Transaction) {
                    ((Transaction)transaction).setUser(id, email, username, domain);
                }
            }
        }
    }

    public static class SetFrameworkNameInstrumentation
    extends TransactionInstrumentation {
        public SetFrameworkNameInstrumentation() {
            super(ElementMatchers.named("setFrameworkName"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setFrameworkName(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object transaction, @Advice.Argument(value=0) String frameworkName) {
                if (transaction instanceof Transaction) {
                    ((Transaction)transaction).setUserFrameworkName(frameworkName);
                }
            }
        }
    }
}

