/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.pluginapi.ApiInstrumentation;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@Deprecated
public class LegacySpanInstrumentation
extends ApiInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public LegacySpanInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.SpanImpl").and(ElementMatchers.not(ElementMatchers.hasSuperType(ElementMatchers.named("co.elastic.apm.api.AbstractSpanImpl"))));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class IsSampledInstrumentation
    extends LegacySpanInstrumentation {
        public IsSampledInstrumentation() {
            super(ElementMatchers.named("isSampled"));
        }

        public static class AdviceClass {
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(inline=false)
            public static boolean isSampled(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span, @Advice.Return boolean returnValue) {
                if (span instanceof Span) {
                    return ((AbstractSpan)span).isSampled();
                }
                return returnValue;
            }
        }
    }

    public static class ActivateInstrumentation
    extends LegacySpanInstrumentation {
        public ActivateInstrumentation() {
            super(ElementMatchers.named("activate"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(inline=false)
            public static void activate(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span) {
                if (span instanceof Span) {
                    ((Span)span).activate();
                }
            }
        }
    }

    public static class AddTagInstrumentation
    extends LegacySpanInstrumentation {
        public AddTagInstrumentation() {
            super(ElementMatchers.named("addTag"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(inline=false)
            public static void addTag(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) String value) {
                if (span instanceof Span) {
                    ((Span)span).addLabel(key, value);
                }
            }
        }
    }

    public static class GetTraceIdInstrumentation
    extends LegacySpanInstrumentation {
        public GetTraceIdInstrumentation() {
            super(ElementMatchers.named("getTraceId").and(ElementMatchers.takesArguments(0)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(inline=false)
            public static String getTraceId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span, @Advice.Return @Nullable String returnValue) {
                if (span instanceof Span) {
                    return ((Span)span).getTraceContext().getTraceId().toString();
                }
                return returnValue;
            }
        }
    }

    public static class GetIdInstrumentation
    extends LegacySpanInstrumentation {
        public GetIdInstrumentation() {
            super(ElementMatchers.named("getId").and(ElementMatchers.takesArguments(0)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(inline=false)
            public static String getId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span, @Advice.Return @Nullable String returnValue) {
                if (span instanceof Span) {
                    return ((Span)span).getTraceContext().getId().toString();
                }
                return returnValue;
            }
        }
    }

    public static class CaptureExceptionInstrumentation
    extends LegacySpanInstrumentation {
        public CaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException").and(ElementMatchers.takesArguments(Throwable.class)));
        }

        public static class AdviceClass {
            @Advice.OnMethodExit(inline=false)
            public static void captureException(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span, @Advice.Argument(value=0) Throwable t) {
                if (span instanceof Span) {
                    ((Span)span).captureException(t);
                }
            }
        }
    }

    public static class EndInstrumentation
    extends LegacySpanInstrumentation {
        public EndInstrumentation() {
            super(ElementMatchers.named("end"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(inline=false)
            public static void end(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span) {
                if (span instanceof Span) {
                    ((Span)span).end();
                }
            }
        }
    }

    public static class DoCreateSpanInstrumentation
    extends LegacySpanInstrumentation {
        public DoCreateSpanInstrumentation() {
            super(ElementMatchers.named("doCreateSpan"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(inline=false)
            public static Object doCreateSpan(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span) {
                if (span instanceof Span) {
                    return ((Span)span).createSpan();
                }
                return null;
            }
        }
    }

    public static class SetTypeInstrumentation
    extends LegacySpanInstrumentation {
        public SetTypeInstrumentation() {
            super(ElementMatchers.named("setType"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(inline=false)
            public static void setType(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span, @Advice.Argument(value=0) String type) {
                if (span instanceof Span) {
                    ((Span)span).setType(type, null, null);
                }
            }
        }
    }

    public static class SetNameInstrumentation
    extends LegacySpanInstrumentation {
        public SetNameInstrumentation() {
            super(ElementMatchers.named("setName"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(inline=false)
            public static void setName(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Object span, @Advice.Argument(value=0) String name) {
                if (span instanceof Span) {
                    ((Span)span).withName(name, 1000);
                }
            }
        }
    }
}

