/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.pluginapi.ApiInstrumentation;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class CaptureExceptionInstrumentation
extends ApiInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.NoopTransaction").or(ElementMatchers.named("co.elastic.apm.api.NoopSpan"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("captureException").and(ElementMatchers.takesArguments(Throwable.class));
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void captureException(@Advice.Origin Class<?> clazz, @Advice.Argument(value=0) Throwable t) {
            TracerAwareInstrumentation.tracer.captureAndReportException(t, PrivilegedActionUtils.getClassLoader(clazz));
        }
    }
}

