/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracingimpl;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.opentracingimpl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.opentracingimpl.OpenTracingTextMapBridge;
import java.util.Map;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ExternalSpanContextInstrumentation
extends OpenTracingBridgeInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ExternalSpanContextInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ExternalProcessSpanContext");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Nullable
    public static TraceContext parseTextMap(Iterable<Map.Entry<String, String>> textMap) {
        ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
        if (tracer != null) {
            TraceContext childTraceContext = TraceContext.with64BitId(tracer);
            if (TraceContext.getFromTraceContextTextHeaders().asChildOf(childTraceContext, textMap, OpenTracingTextMapBridge.instance())) {
                return childTraceContext;
            }
        }
        return null;
    }

    public static class ToSpanIdInstrumentation
    extends ExternalSpanContextInstrumentation {
        public ToSpanIdInstrumentation() {
            super(ElementMatchers.named("toSpanId"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToFields(value={@Advice.AssignReturned.ToFields.ToField(value="childTraceContext")})
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object toSpanId(@Advice.FieldValue(value="textMap", typing=Assigner.Typing.DYNAMIC) @Nullable Iterable<Map.Entry<String, String>> textMap, @Advice.FieldValue(value="childTraceContext", typing=Assigner.Typing.DYNAMIC) @Nullable Object childTraceContextObj) {
                if (textMap == null) {
                    return childTraceContextObj;
                }
                return ExternalSpanContextInstrumentation.parseTextMap(textMap);
            }

            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static String onExit(@Advice.FieldValue(value="childTraceContext", typing=Assigner.Typing.DYNAMIC) @Nullable Object childTraceContextObj) {
                if (!(childTraceContextObj instanceof TraceContext)) {
                    return null;
                }
                return ((TraceContext)childTraceContextObj).getParentId().toString();
            }
        }
    }

    public static class ToTraceIdInstrumentation
    extends ExternalSpanContextInstrumentation {
        public ToTraceIdInstrumentation() {
            super(ElementMatchers.named("toTraceId"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToFields(value={@Advice.AssignReturned.ToFields.ToField(value="childTraceContext")})
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object toTraceId(@Advice.FieldValue(value="textMap", typing=Assigner.Typing.DYNAMIC) @Nullable Iterable<Map.Entry<String, String>> textMap, @Advice.FieldValue(value="childTraceContext", typing=Assigner.Typing.DYNAMIC) @Nullable Object childTraceContextObj) {
                if (textMap == null) {
                    return childTraceContextObj;
                }
                return ExternalSpanContextInstrumentation.parseTextMap(textMap);
            }

            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static String onExit(@Advice.FieldValue(value="childTraceContext", typing=Assigner.Typing.DYNAMIC) @Nullable Object childTraceContextObj) {
                if (!(childTraceContextObj instanceof TraceContext)) {
                    return null;
                }
                return ((TraceContext)childTraceContextObj).getTraceId().toString();
            }
        }
    }
}

