/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracingimpl;

import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.opentracingimpl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.Map;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ApmSpanInstrumentation
extends OpenTracingBridgeInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(ApmSpanInstrumentation.class);
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ApmSpanInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmSpan");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class GetTraceContextInstrumentation
    extends ApmSpanInstrumentation {
        public GetTraceContextInstrumentation() {
            super(ElementMatchers.named("getTraceContext"));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.AssignReturned.ToReturned
            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static Object getTraceContext(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) @Nullable Object abstractSpanObj) {
                return abstractSpanObj;
            }
        }
    }

    public static class TagInstrumentation
    extends ApmSpanInstrumentation {
        public TagInstrumentation() {
            super(ElementMatchers.named("handleTag"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void handleTag(@Advice.FieldValue(value="dispatcher", typing=Assigner.Typing.DYNAMIC) @Nullable Object abstractSpanObj, @Advice.Argument(value=0) String key, @Advice.Argument(value=1) @Nullable Object value) {
                if (value == null) {
                    return;
                }
                if (abstractSpanObj instanceof Transaction) {
                    AdviceClass.handleTransactionTag((Transaction)abstractSpanObj, key, value);
                } else if (abstractSpanObj instanceof Span) {
                    AdviceClass.handleSpanTag((Span)abstractSpanObj, key, value);
                } else {
                    logger.warn("Calling setTag on an already finished span");
                }
            }

            private static void handleTransactionTag(Transaction transaction, String key, Object value) {
                if (!AdviceClass.handleSpecialTransactionTag(transaction, key, value)) {
                    AdviceClass.addTag(transaction, key, value);
                }
            }

            private static void handleSpanTag(Span span, String key, Object value) {
                if (!AdviceClass.handleSpecialSpanTag(span, key, value)) {
                    AdviceClass.addTag(span, key, value);
                }
            }

            private static void addTag(AbstractSpan<?> transaction, String key, Object value) {
                if (value instanceof Number) {
                    transaction.addLabel(key, (Number)value);
                } else if (value instanceof Boolean) {
                    transaction.addLabel(key, (Boolean)value);
                } else {
                    transaction.addLabel(key, value.toString());
                }
            }

            private static boolean handleSpecialTransactionTag(Transaction transaction, String key, Object value) {
                if ("type".equals(key)) {
                    transaction.withType(value.toString());
                    return true;
                }
                if ("result".equals(key)) {
                    transaction.withResult(value.toString());
                    return true;
                }
                if ("error".equals(key)) {
                    if (Boolean.TRUE.equals(value)) {
                        transaction.withResultIfUnset("error");
                    }
                    return true;
                }
                if ("http.status_code".equals(key) && value instanceof Number) {
                    int status = ((Number)value).intValue();
                    transaction.getContext().getResponse().withStatusCode(status);
                    transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(status));
                    transaction.withOutcome(ResultUtil.getOutcomeByHttpServerStatus(status));
                    transaction.withType("request");
                    return true;
                }
                if ("http.method".equals(key)) {
                    transaction.getContext().getRequest().withMethod(value.toString());
                    transaction.withType("request");
                    return true;
                }
                if ("http.url".equals(key)) {
                    transaction.getContext().getRequest().getUrl().withFull(value.toString());
                    transaction.withType("request");
                    return true;
                }
                if ("sampling.priority".equals(key)) {
                    return true;
                }
                if ("user.id".equals(key)) {
                    transaction.getContext().getUser().withId(value.toString());
                    return true;
                }
                if ("user.email".equals(key)) {
                    transaction.getContext().getUser().withEmail(value.toString());
                    return true;
                }
                if ("user.username".equals(key)) {
                    transaction.getContext().getUser().withUsername(value.toString());
                    return true;
                }
                return false;
            }

            private static boolean handleSpecialSpanTag(Span span, String key, Object value) {
                if ("type".equals(key)) {
                    if (span.getSubtype() == null && span.getAction() == null) {
                        span.setType(value.toString(), null, null);
                    } else {
                        span.withType(value.toString());
                    }
                    return true;
                }
                if ("subtype".equals(key)) {
                    span.withSubtype(value.toString());
                    return true;
                }
                if ("action".equals(key)) {
                    span.withAction(value.toString());
                    return true;
                }
                if ("sampling.priority".equals(key)) {
                    return true;
                }
                if ("db.type".equals(key)) {
                    span.getContext().getDb().withType(value.toString());
                    ((Span)span.withType("db")).withSubtype(value.toString());
                    return true;
                }
                if ("db.instance".equals(key)) {
                    span.getContext().getDb().withInstance(value.toString());
                    return true;
                }
                if ("db.statement".equals(key)) {
                    span.getContext().getDb().withStatement(value.toString());
                    span.withAction("query");
                    return true;
                }
                if ("span.kind".equals(key)) {
                    if (span.getType() == null && ("producer".equals(value) || "client".equals(value))) {
                        span.withType("external");
                    }
                    return true;
                }
                if ("http.status_code".equals(key) && value instanceof Number) {
                    int status = ((Number)value).intValue();
                    span.getContext().getHttp().withStatusCode(status);
                    span.withSubtype("http").withOutcome(ResultUtil.getOutcomeByHttpClientStatus(status));
                    return true;
                }
                if ("http.url".equals(key) && value instanceof String) {
                    span.getContext().getHttp().withUrl((String)value);
                    return true;
                }
                if ("http.method".equals(key) && value instanceof String) {
                    span.getContext().getHttp().withMethod((String)value);
                    return true;
                }
                return false;
            }
        }
    }

    public static class LogInstrumentation
    extends ApmSpanInstrumentation {
        public LogInstrumentation() {
            super(ElementMatchers.named("log").and(ElementMatchers.takesArguments(Long.TYPE, Map.class)));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void log(@Advice.FieldValue(value="dispatcher", typing=Assigner.Typing.DYNAMIC) @Nullable Object context, @Advice.Argument(value=0) long epochTimestampMicros, @Advice.Argument(value=1) Map<String, ?> fields) {
                if (context instanceof AbstractSpan) {
                    Object errorObject;
                    AbstractSpan span = (AbstractSpan)context;
                    if ("error".equals(fields.get("event")) && (errorObject = fields.get("error.object")) instanceof Throwable) {
                        if (epochTimestampMicros > 0L) {
                            span.captureExceptionAndGetErrorId(epochTimestampMicros, (Throwable)errorObject);
                        } else {
                            span.captureException((Throwable)errorObject);
                        }
                    }
                } else {
                    logger.warn("Calling log on an already finished span");
                }
            }
        }
    }

    public static class SetOperationName
    extends ApmSpanInstrumentation {
        public SetOperationName() {
            super(ElementMatchers.named("setOperationName"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void setOperationName(@Advice.FieldValue(value="dispatcher", typing=Assigner.Typing.DYNAMIC) @Nullable Object context, @Advice.Argument(value=0) @Nullable String operationName) {
                if (context instanceof AbstractSpan) {
                    ((AbstractSpan)context).withName(operationName, 1000);
                } else {
                    logger.warn("Calling setOperationName on an already finished span");
                }
            }
        }
    }

    public static class FinishInstrumentation
    extends ApmSpanInstrumentation {
        public FinishInstrumentation() {
            super(ElementMatchers.named("finishInternal"));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void finishInternal(@Advice.FieldValue(value="dispatcher", typing=Assigner.Typing.DYNAMIC) @Nullable Object context, @Advice.Argument(value=0) long finishMicros) {
                if (context instanceof AbstractSpan) {
                    AdviceClass.doFinishInternal((AbstractSpan)context, finishMicros);
                }
            }

            public static void doFinishInternal(AbstractSpan<?> abstractSpan, long finishMicros) {
                Transaction transaction;
                abstractSpan.incrementReferences();
                if (abstractSpan instanceof Transaction && (transaction = (Transaction)abstractSpan).getType() == null && transaction.getContext().getRequest().hasContent()) {
                    transaction.withType("request");
                }
                if (finishMicros >= 0L) {
                    abstractSpan.end(finishMicros);
                } else {
                    abstractSpan.end();
                }
            }
        }
    }
}

