/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentelemetry.sdk;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.MultiValueMapAccessor;
import co.elastic.apm.agent.impl.transaction.OTelSpanKind;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.opentelemetry.sdk.OTelSpan;
import co.elastic.apm.agent.opentelemetry.sdk.OTelSpanContext;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.LoggerUtils;
import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import co.elastic.apm.agent.util.VersionUtils;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class OTelSpanBuilder
implements SpanBuilder {
    private static final Logger addLinkLogger = LoggerUtils.logOnce(LoggerFactory.getLogger(OTelSpanBuilder.class));
    private final String spanName;
    private final ElasticApmTracer elasticApmTracer;
    private final Map<AttributeKey<?>, Object> attributes = new HashMap();
    private long epochMicros = -1L;
    @Nullable
    private AbstractSpan<?> parent;
    @Nullable
    private Context remoteContext;
    private List<SpanContext> links = new ArrayList<SpanContext>();
    @Nullable
    private SpanKind kind;

    public OTelSpanBuilder(String spanName, ElasticApmTracer elasticApmTracer) {
        this.spanName = spanName;
        this.elasticApmTracer = elasticApmTracer;
    }

    public SpanBuilder setParent(Context context) {
        Span span = Span.fromContext((Context)context);
        if (span.getSpanContext().isRemote()) {
            this.remoteContext = context;
        } else if (span instanceof OTelSpan) {
            this.parent = ((OTelSpan)span).getInternalSpan();
        }
        return this;
    }

    public SpanBuilder setNoParent() {
        this.parent = null;
        this.remoteContext = null;
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext) {
        this.links.add(spanContext);
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext, Attributes attributes1) {
        this.addLink(spanContext);
        if (attributes1 != null && !attributes1.isEmpty()) {
            addLinkLogger.warn("Adding attributes to links is currently unsupported - the links have been added but with no attributes, the following attributes have been ignored: %s", (Object)attributes1);
        }
        return this;
    }

    public SpanBuilder setAttribute(String key, @Nonnull String value) {
        this.setAttribute(AttributeKey.stringKey((String)key), value);
        return this;
    }

    public SpanBuilder setAttribute(String key, long value) {
        this.setAttribute(AttributeKey.longKey((String)key), Long.valueOf(value));
        return this;
    }

    public SpanBuilder setAttribute(String key, double value) {
        this.setAttribute(AttributeKey.doubleKey((String)key), Double.valueOf(value));
        return this;
    }

    public SpanBuilder setAttribute(String key, boolean value) {
        this.setAttribute(AttributeKey.booleanKey((String)key), Boolean.valueOf(value));
        return this;
    }

    public <T> SpanBuilder setAttribute(AttributeKey<T> key, @Nonnull T value) {
        this.attributes.put(key, value);
        return this;
    }

    public SpanBuilder setSpanKind(SpanKind spanKind) {
        this.kind = spanKind;
        return this;
    }

    public SpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        this.epochMicros = unit.toMicros(startTimestamp);
        return this;
    }

    public Span startSpan() {
        AbstractSpan span;
        if (this.parent == null) {
            this.parent = this.elasticApmTracer.getActive();
        }
        if (this.remoteContext != null) {
            PotentiallyMultiValuedMap headers = new PotentiallyMultiValuedMap(2);
            W3CTraceContextPropagator.getInstance().inject(this.remoteContext, (Object)headers, PotentiallyMultiValuedMap::add);
            span = this.elasticApmTracer.startChildTransaction(headers, MultiValueMapAccessor.INSTANCE, PrivilegedActionUtils.getClassLoader(this.getClass()), this.epochMicros);
        } else {
            span = this.parent == null ? this.elasticApmTracer.startRootTransaction(PrivilegedActionUtils.getClassLoader(this.getClass()), this.epochMicros) : this.elasticApmTracer.startSpan(this.parent, this.epochMicros);
        }
        if (span == null) {
            return Span.getInvalid();
        }
        span.withName(this.spanName);
        if (span instanceof Transaction) {
            Transaction t = (Transaction)span;
            t.setFrameworkName("OpenTelemetry API");
            String otelVersion = VersionUtils.getVersion(OpenTelemetry.class, "io.opentelemetry", "opentelemetry-api");
            if (otelVersion != null) {
                t.setFrameworkVersion(otelVersion);
            }
        }
        if (this.kind == null) {
            span.withOtelKind(OTelSpanKind.INTERNAL);
        } else {
            span.withOtelKind(OTelSpanKind.valueOf(this.kind.name()));
        }
        span.withUserOutcome(Outcome.UNKNOWN);
        for (int i = 0; i < this.links.size(); ++i) {
            span.addSpanLink(TraceContext.fromParentContext(), ((OTelSpanContext)this.links.get(i)).getElasticTraceContext());
        }
        OTelSpan otelSpan = new OTelSpan(span);
        this.attributes.forEach((k, v) -> otelSpan.setAttribute(k, v));
        return otelSpan;
    }
}

