/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentelemetry.context;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.ElasticContext;
import co.elastic.apm.agent.opentelemetry.sdk.OTelBridgeContext;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import javax.annotation.Nullable;

public class OTelContextStorage
implements ContextStorage {
    private static final Logger logger = LoggerFactory.getLogger(OTelContextStorage.class);
    private final ElasticApmTracer tracer;

    public OTelContextStorage(ElasticApmTracer tracer) {
        this.tracer = tracer;
    }

    public Scope attach(@Nullable Context toAttach) {
        if (toAttach == null) {
            return Scope.noop();
        }
        if (toAttach == this.tracer.currentContext()) {
            return Scope.noop();
        }
        if (!(toAttach instanceof OTelBridgeContext)) {
            logger.debug("unexpected context type for attachment {}", (Object)toAttach.getClass().getName());
            return Scope.noop();
        }
        OTelBridgeContext bridgeContext = (OTelBridgeContext)toAttach;
        this.tracer.activate(bridgeContext);
        return bridgeContext;
    }

    @Nullable
    public Context current() {
        ElasticContext<?> current = this.tracer.currentContext();
        if (current == null) {
            return null;
        }
        if (current instanceof OTelBridgeContext) {
            return (Context)current;
        }
        AbstractSpan<?> currentSpan = current.getSpan();
        if (currentSpan == null) {
            return null;
        }
        Context.root();
        return this.tracer.wrapActiveContextIfRequired(OTelBridgeContext.class, () -> OTelBridgeContext.wrapElasticActiveSpan(this.tracer, currentSpan));
    }
}

