/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentelemetry;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.opentelemetry.AbstractOpenTelemetryInstrumentation;
import co.elastic.apm.agent.opentelemetry.sdk.OTelBridgeContext;
import io.opentelemetry.context.Context;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ArrayBasedContextInstrumentation
extends AbstractOpenTelemetryInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.opentelemetry.context.ArrayBasedContext");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("root").and(ElementMatchers.isStatic()).and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("io.opentelemetry.context.Context")))).and(ElementMatchers.takesNoArguments());
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.opentelemetry.ArrayBasedContextInstrumentation$RootAdvice";
    }

    public static class RootAdvice {
        @Nullable
        @Advice.AssignReturned.ToReturned
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static Context onExit(@Advice.Return @Nullable Context returnValue) {
            if (returnValue == null) {
                return null;
            }
            return OTelBridgeContext.bridgeRootContext(GlobalTracer.requireTracerImpl(), returnValue);
        }
    }
}

