/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool.impl;

import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.Resetter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class AbstractObjectPool<T>
implements ObjectPool<T> {
    protected final Allocator<T> allocator;
    protected final Resetter<T> resetter;
    private final AtomicInteger garbageCreated;

    protected AbstractObjectPool(Allocator<T> allocator, Resetter<T> resetter) {
        this.allocator = allocator;
        this.resetter = resetter;
        this.garbageCreated = new AtomicInteger();
    }

    @Override
    public final T createInstance() {
        T object = this.tryCreateInstance();
        if (object == null) {
            object = this.allocator.createInstance();
        }
        return object;
    }

    @Override
    public final void recycle(T obj) {
        this.resetter.recycle(obj);
        if (!this.returnToPool(obj)) {
            this.garbageCreated.incrementAndGet();
        }
    }

    @Override
    public final long getGarbageCreated() {
        return this.garbageCreated.longValue();
    }

    protected abstract boolean returnToPool(T var1);

    @Nullable
    protected abstract T tryCreateInstance();
}

