/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.mongodb.v3;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.mongodb.MongoHelper;
import co.elastic.apm.agent.mongodb.v3.Mongo3Instrumentation;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.connection.Connection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ConnectionInstrumentation
extends Mongo3Instrumentation {
    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("insert").or(ElementMatchers.named("delete")).or(ElementMatchers.named("update")).or(ElementMatchers.named("query")).or(ElementMatchers.named("getMore")).or(ElementMatchers.named("insertCommand")).or(ElementMatchers.named("updateCommand")).or(ElementMatchers.named("deleteCommand")).and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.mongodb.MongoNamespace")));
    }

    public static class AdviceClass {
        private static final MongoHelper helper = new MongoHelper();

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.This Connection thiz, @Advice.Argument(value=0) MongoNamespace namespace, @Advice.Origin(value="#m") String methodName) {
            int indexOfCommand;
            String command = methodName;
            if (methodName.equals("query")) {
                command = "find";
            }
            if ((indexOfCommand = command.indexOf("Command")) > 0) {
                command = command.substring(0, indexOfCommand);
            }
            ServerAddress address = thiz.getDescription().getServerAddress();
            return helper.startSpan(namespace.getDatabaseName(), namespace.getCollectionName(), command, address.getHost(), address.getPort(), null);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Nullable @Advice.Enter Object spanObj, @Advice.Thrown Throwable thrown) {
            if (spanObj instanceof Span) {
                Span span = (Span)spanObj;
                ((Span)span.deactivate()).captureException(thrown);
                span.end();
            }
        }
    }
}

