/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.mongodb.v3;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.mongodb.MongoHelper;
import co.elastic.apm.agent.mongodb.v3.Mongo3Instrumentation;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.connection.Connection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.bson.BsonDocument;

public class ConnectionCommandInstrumentation
extends Mongo3Instrumentation {
    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("command").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, ElementMatchers.is(String.class).or(ElementMatchers.named("com.mongodb.MongoNamespace")))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.bson.BsonDocument")));
    }

    public static class AdviceClass {
        private static final MongoHelper helper = new MongoHelper();

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.This Connection thiz, @Advice.Argument(value=0) Object databaseOrMongoNamespace, @Advice.Argument(value=1) BsonDocument command) {
            String database = null;
            String collection = null;
            if (databaseOrMongoNamespace instanceof String) {
                database = (String)databaseOrMongoNamespace;
            } else if (databaseOrMongoNamespace instanceof MongoNamespace) {
                MongoNamespace namespace = (MongoNamespace)databaseOrMongoNamespace;
                database = namespace.getDatabaseName();
                collection = namespace.getCollectionName();
            }
            String cmd = helper.getCommandFromBson(command);
            if (collection == null) {
                collection = helper.getCollectionFromBson(cmd, command);
            }
            ServerAddress address = thiz.getDescription().getServerAddress();
            return helper.startSpan(database, collection, cmd, address.getHost(), address.getPort(), command);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Nullable @Advice.Enter Object spanObj, @Advice.Thrown Throwable thrown) {
            if (spanObj instanceof Span) {
                Span span = (Span)spanObj;
                ((Span)((Span)span.deactivate()).captureException(thrown)).end();
            }
        }
    }
}

