/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.mongodb;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.mongodb.MongoConfiguration;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import javax.annotation.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class MongoHelper {
    private static final Logger logger = LoggerFactory.getLogger(MongoHelper.class);
    private final ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
    private final MongoConfiguration config = this.tracer.getConfig(MongoConfiguration.class);

    public Span startSpan(@Nullable String database, @Nullable String collection, @Nullable String command, String host, int port, @Nullable BsonDocument commandDocument) {
        Span span = null;
        AbstractSpan<?> activeSpan = this.tracer.getActive();
        if (activeSpan != null) {
            span = activeSpan.createExitSpan();
        }
        if (span == null) {
            return null;
        }
        ((Span)span.withType("db")).withSubtype("mongodb").withAction(command).getContext().getDb().withType("mongodb");
        span.getContext().getServiceTarget().withType("mongodb").withName(database);
        String statement = null;
        if (command != null && commandDocument != null && WildcardMatcher.anyMatch(this.config.getCaptureStatementCommands(), command) != null) {
            statement = commandDocument.toJson();
        }
        span.getContext().getDb().withInstance(database).withStatement(statement);
        StringBuilder name = span.getAndOverrideName(0);
        if (name != null) {
            MongoHelper.appendToName(name, database);
            MongoHelper.appendToName(name, collection);
            MongoHelper.appendToName(name, command);
        }
        span.getContext().getDestination().withAddress(host).withPort(port);
        return (Span)span.activate();
    }

    @Nullable
    public String getCommandFromBson(BsonDocument document) {
        String cmd = null;
        try {
            cmd = document.containsKey((Object)"find") ? "find" : (document.containsKey((Object)"insert") ? "insert" : (document.containsKey((Object)"count") ? "count" : (document.containsKey((Object)"drop") ? "drop" : (document.containsKey((Object)"update") ? "update" : (document.containsKey((Object)"delete") ? "delete" : (document.containsKey((Object)"create") ? "create" : (document.containsKey((Object)"getMore") ? "getMore" : (String)document.keySet().iterator().next())))))));
        }
        catch (RuntimeException e) {
            logger.error("Exception while determining MongoDB command and collection", e);
        }
        return cmd;
    }

    @Nullable
    public String getCollectionFromBson(String name, BsonDocument document) {
        String collection = null;
        BsonValue bsonValue = document.get((Object)name);
        if (bsonValue != null && bsonValue.isString()) {
            collection = bsonValue.asString().getValue();
        }
        if (collection == null && (bsonValue = document.get((Object)"collection")) != null && bsonValue.isString()) {
            collection = bsonValue.asString().getValue();
        }
        return collection;
    }

    private static void appendToName(StringBuilder name, @Nullable String value) {
        if (value == null) {
            return;
        }
        if (name.length() > 0) {
            name.append('.');
        }
        name.append(value);
    }
}

