/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.micrometer;

import co.elastic.apm.agent.configuration.MetricsConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.micrometer.MicrometerMeterRegistrySerializer;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import com.dslplatform.json.JsonWriter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.simple.CountingMode;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class MicrometerMetricsReporter
implements Runnable,
Closeable {
    private static final long INTERVAL_BETWEEN_CHECKS_IN_MILLISECONDS = 1000L;
    private static final Logger logger;
    private static final boolean HAS_SimpleMeterRegistry_METHOD;
    private volatile long lastMetricIntervalTimestamp = System.currentTimeMillis();
    private final WeakMap<MeterRegistry, Step> meterRegistries = WeakConcurrent.buildMap();
    private final WeakMap<MeterRegistry, SimpleConfig> configMap = WeakConcurrent.buildMap();
    private final MicrometerMeterRegistrySerializer serializer;
    private final Reporter reporter;
    private final ElasticApmTracer tracer;
    private final AtomicBoolean scheduledReporting = new AtomicBoolean();
    private final boolean disableScheduler;

    public MicrometerMetricsReporter(ElasticApmTracer tracer) {
        this(tracer, false);
    }

    MicrometerMetricsReporter(ElasticApmTracer tracer, boolean disableSchedulerThread) {
        this.tracer = tracer;
        this.reporter = tracer.getReporter();
        tracer.addShutdownHook(this);
        this.serializer = new MicrometerMeterRegistrySerializer(tracer.getConfig(MetricsConfiguration.class));
        this.disableScheduler = disableSchedulerThread;
    }

    void registerMeterRegistry(MeterRegistry meterRegistry) {
        if (meterRegistry instanceof CompositeMeterRegistry) {
            return;
        }
        long step = this.getStep(meterRegistry);
        if (step >= 0L && step < 1000L) {
            logger.warn("Not registering unsupported step interval of {} milliseconds (1 seconds is the minimum supported) for Micrometer MeterRegistry: {}", (Object)step, (Object)meterRegistry);
            return;
        }
        Step newStep = new Step(step);
        Step hopefullyNull = this.meterRegistries.putIfAbsent(meterRegistry, newStep);
        if (hopefullyNull != null) {
            logger.info("Not re-registering MeterRegistry as it is already registered from another compound meter registry: {}", (Object)meterRegistry);
        } else {
            logger.info("Registering Micrometer MeterRegistry: {}", (Object)meterRegistry);
        }
        this.scheduleReporting();
    }

    private synchronized void scheduleReporting() {
        if (this.disableScheduler) {
            return;
        }
        if (this.scheduledReporting.compareAndSet(false, true)) {
            this.tracer.getSharedSingleThreadedPool().scheduleAtFixedRate(this, 0L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void run() {
        this.run(System.currentTimeMillis());
    }

    void run(long now) {
        if (this.tracer.getState() != Tracer.TracerState.RUNNING) {
            return;
        }
        long metricsIntervalMs = this.tracer.getConfig(ReporterConfiguration.class).getMetricsIntervalMs();
        if (metricsIntervalMs == 0L) {
            return;
        }
        boolean reportNonStepMetrics = false;
        if (now - this.lastMetricIntervalTimestamp >= metricsIntervalMs) {
            reportNonStepMetrics = true;
            this.lastMetricIntervalTimestamp += metricsIntervalMs;
        }
        Iterator registriesIterator = this.meterRegistries.iterator();
        HashSet<MeterRegistry> currentlyReportableRegistries = new HashSet<MeterRegistry>();
        while (registriesIterator.hasNext()) {
            Map.Entry meterRegistryStepEntry = (Map.Entry)registriesIterator.next();
            MeterRegistry meterRegistry = (MeterRegistry)meterRegistryStepEntry.getKey();
            Step meterRegistryStep = (Step)meterRegistryStepEntry.getValue();
            if (meterRegistryStep.isStep()) {
                logger.debug("Evaluating whether to report: step {}, interval(ms) {}, meterRegistry {}", meterRegistryStep.lastStepCount, meterRegistryStep.stepInMs, meterRegistry);
                if (!meterRegistryStep.shouldReportNow(now)) continue;
                currentlyReportableRegistries.add(meterRegistry);
                meterRegistryStep.incrementToNextStep(now);
                continue;
            }
            if (!reportNonStepMetrics) continue;
            currentlyReportableRegistries.add(meterRegistry);
        }
        MeterMapConsumer meterConsumer = MeterMapConsumer.INSTANCE.reset(this.tracer.getConfig(ReporterConfiguration.class).getDisableMetrics());
        for (MeterRegistry registry : currentlyReportableRegistries) {
            registry.forEachMeter((Consumer)meterConsumer);
        }
        logger.debug("Reporting {} meters", (Object)meterConsumer.meters.size());
        for (JsonWriter serializedMetricSet : this.serializer.serialize(meterConsumer.meters, now * 1000L)) {
            this.reporter.report(serializedMetricSet);
        }
    }

    private long getStep(MeterRegistry meterRegistry) {
        if (meterRegistry.config() instanceof StepRegistryConfig) {
            return ((StepRegistryConfig)meterRegistry.config()).step().toMillis();
        }
        if (meterRegistry instanceof SimpleMeterRegistry) {
            SimpleConfig config;
            if (!this.configMap.containsKey(meterRegistry)) {
                if (HAS_SimpleMeterRegistry_METHOD) {
                    ((SimpleMeterRegistry)meterRegistry).getMetersAsString();
                } else {
                    return -1L;
                }
            }
            return (config = this.configMap.get(meterRegistry)) != null && CountingMode.STEP.equals((Object)config.mode()) ? config.step().toMillis() : -1L;
        }
        return -1L;
    }

    @Override
    public void close() {
        this.tracer.getSharedSingleThreadedPool().submit(this);
    }

    public void addConfig(MeterRegistry meterRegistry, SimpleConfig config) {
        if (this.configMap.putIfAbsent(meterRegistry, config) != null) {
            return;
        }
        logger.warn("Identified Micrometer SimpleConfig: {}", (Object)config);
        if (config.getClass().getName().equals("co.elastic.apm.agent.micrometer.MicrometerMetricsReporter$OneSecondStepSimpleConfig")) {
            meterRegistry.counter("MicrometerMetricsReporter_OneSecondStepSimpleConfig", new String[0]).increment((double)config.hashCode());
        }
    }

    WeakMap<MeterRegistry, Step> getMeterRegistries() {
        return this.meterRegistries;
    }

    Iterable<Meter> getFailedMeters() {
        return this.serializer.getFailedMeters();
    }

    void resetNow(long now) {
        this.lastMetricIntervalTimestamp = now;
    }

    static {
        boolean hasSimpleMeterRegistryMethod1;
        logger = LoggerFactory.getLogger(MicrometerMetricsReporter.class);
        try {
            Class<?> simpleMeterRegistryClass = Class.forName("io.micrometer.core.instrument.simple.SimpleMeterRegistry");
            simpleMeterRegistryClass.getDeclaredMethod("getMetersAsString", new Class[0]);
            hasSimpleMeterRegistryMethod1 = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            hasSimpleMeterRegistryMethod1 = false;
        }
        HAS_SimpleMeterRegistry_METHOD = hasSimpleMeterRegistryMethod1;
    }

    static class OneSecondStepSimpleConfig
    implements SimpleConfig {
        OneSecondStepSimpleConfig() {
        }

        public CountingMode mode() {
            return CountingMode.STEP;
        }

        public Duration step() {
            return Duration.ofSeconds(1L);
        }

        public String get(String key) {
            return null;
        }
    }

    static class Step {
        long lastStepCount = 0L;
        long stepInMs;

        public Step(long step) {
            this.stepInMs = step;
        }

        public boolean isStep() {
            return this.stepInMs > 0L;
        }

        public boolean shouldReportNow(long now) {
            long newStepCount = now / this.stepInMs;
            return newStepCount > this.lastStepCount;
        }

        public void incrementToNextStep(long now) {
            this.lastStepCount = now / this.stepInMs;
        }
    }

    private static class MeterMapConsumer
    implements Consumer<Meter> {
        static final MeterMapConsumer INSTANCE = new MeterMapConsumer(null);
        private List<WildcardMatcher> disabledMetrics;
        final Map<Meter.Id, Meter> meters = new HashMap<Meter.Id, Meter>();

        public MeterMapConsumer(List<WildcardMatcher> disabledMetrics) {
            this.disabledMetrics = disabledMetrics;
        }

        public MeterMapConsumer reset(List<WildcardMatcher> disabledMetrics2) {
            this.disabledMetrics = disabledMetrics2;
            this.meters.clear();
            return this;
        }

        @Override
        public void accept(Meter meter) {
            Meter.Id meterId = meter.getId();
            if (WildcardMatcher.isNoneMatch(this.disabledMetrics, meterId.getName())) {
                this.meters.put(meterId, meter);
            }
        }
    }
}

