/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics.builtin;

import co.elastic.apm.agent.configuration.MetricsConfiguration;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricCollector;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.metrics.MetricsProvider;
import co.elastic.apm.agent.report.ReporterMonitor;
import co.elastic.apm.agent.report.ReportingEvent;
import co.elastic.apm.agent.report.ReportingEventCounter;
import co.elastic.apm.agent.util.AtomicDouble;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentReporterMetrics
implements ReporterMonitor {
    private static final Logger logger = LoggerFactory.getLogger(AgentReporterMetrics.class);
    private final MetricRegistry metricRegistry;
    private static final String TOTAL_EVENTS_METRIC = "agent.events.total";
    private static final String DROPPED_EVENTS_METRIC = "agent.events.dropped";
    private static final String MAX_QUEUE_SIZE_METRIC = "agent.events.queue.max_size.pct";
    private static final String MIN_QUEUE_SIZE_METRIC = "agent.events.queue.min_size.pct";
    private static final String REQUEST_COUNT_METRIC = "agent.events.requests.count";
    private static final String REQUEST_BYTES_METRIC = "agent.events.requests.bytes";
    private final boolean totalEventsMetricEnabled;
    private final boolean droppedEventsMetricEnabled;
    private final boolean minQueueSizeMetricEnabled;
    private final boolean maxQueueSizeMetricEnabled;
    private final boolean requestCountMetricEnabled;
    private final boolean requestBytesMetricEnabled;
    private static final Labels QUEUE_REASON_LABEL = Labels.Mutable.of("reason", "queue").immutableCopy();
    private static final Labels ERROR_REASON_LABEL = Labels.Mutable.of("reason", "error").immutableCopy();
    private static final Labels TRANSACTION_LABEL = Labels.Mutable.of("event_type", "transaction").immutableCopy();
    private static final Labels SPAN_LABEL = Labels.Mutable.of("event_type", "span").immutableCopy();
    private static final Labels ERROR_LABEL = Labels.Mutable.of("event_type", "error").immutableCopy();
    private static final Labels METRICSET_LABEL = Labels.Mutable.of("event_type", "metricset").immutableCopy();
    private static final Labels SUCCESS_LABEL = Labels.Mutable.of("success", "true").immutableCopy();
    private static final Labels FAILURE_LABEL = Labels.Mutable.of("success", "false").immutableCopy();
    private static final Labels GENERIC_QUEUE_LABEL = Labels.Mutable.of("queue_name", "generic").immutableCopy();
    private volatile double currentQueueUtilization = 0.0;
    private final AtomicDouble maxQueueSize = new AtomicDouble(0.0);
    private final AtomicDouble minQueueSize = new AtomicDouble(0.0);

    public AgentReporterMetrics(MetricRegistry registry, MetricsConfiguration configuration) {
        this.metricRegistry = registry;
        boolean allEnabled = configuration.isReporterHealthMetricsEnabled();
        this.totalEventsMetricEnabled = allEnabled && !registry.isDisabled(TOTAL_EVENTS_METRIC);
        this.droppedEventsMetricEnabled = allEnabled && !registry.isDisabled(DROPPED_EVENTS_METRIC);
        this.minQueueSizeMetricEnabled = allEnabled && !registry.isDisabled(MIN_QUEUE_SIZE_METRIC);
        this.maxQueueSizeMetricEnabled = allEnabled && !registry.isDisabled(MAX_QUEUE_SIZE_METRIC);
        this.requestCountMetricEnabled = allEnabled && !registry.isDisabled(REQUEST_COUNT_METRIC);
        boolean bl = this.requestBytesMetricEnabled = allEnabled && !registry.isDisabled(REQUEST_BYTES_METRIC);
        if (this.anyQueueSizeMetricEnabled()) {
            registry.addMetricsProvider(new MetricsProvider(){

                @Override
                public void collectAndReset(MetricCollector collector) {
                    if (AgentReporterMetrics.this.minQueueSizeMetricEnabled) {
                        collector.addMetricValue(AgentReporterMetrics.MIN_QUEUE_SIZE_METRIC, GENERIC_QUEUE_LABEL, AgentReporterMetrics.this.minQueueSize.get());
                    }
                    if (AgentReporterMetrics.this.maxQueueSizeMetricEnabled) {
                        collector.addMetricValue(AgentReporterMetrics.MAX_QUEUE_SIZE_METRIC, GENERIC_QUEUE_LABEL, AgentReporterMetrics.this.maxQueueSize.get());
                    }
                    double currentUtilization = AgentReporterMetrics.this.currentQueueUtilization;
                    AgentReporterMetrics.this.minQueueSize.set(currentUtilization);
                    AgentReporterMetrics.this.maxQueueSize.set(currentUtilization);
                }
            });
        }
    }

    @Override
    public void eventCreated(ReportingEvent.ReportingEventType eventType, long queueCapacity, long queueSizeAfter) {
        Labels label;
        if (this.totalEventsMetricEnabled && (label = this.getLabelFor(eventType)) != null) {
            this.metricRegistry.incrementCounter(TOTAL_EVENTS_METRIC, label);
        }
        this.updateQueueMetric(queueCapacity, queueSizeAfter);
    }

    private void updateQueueMetric(long queueCapacity, long queueSize) {
        if (this.anyQueueSizeMetricEnabled()) {
            double queueUtilization;
            this.currentQueueUtilization = queueUtilization = (double)queueSize / (double)queueCapacity;
            this.maxQueueSize.setWeakMax(queueUtilization);
            this.minQueueSize.setWeakMin(queueUtilization);
        }
    }

    @Override
    public void eventDequeued(ReportingEvent.ReportingEventType eventType, long queueCapacity, long queueSizeAfter) {
        this.updateQueueMetric(queueCapacity, queueSizeAfter);
    }

    @Override
    public void eventDroppedBeforeQueue(ReportingEvent.ReportingEventType eventType, long queueCapacity) {
        Labels label;
        if (this.droppedEventsMetricEnabled && (label = this.getLabelFor(eventType)) != null) {
            this.metricRegistry.incrementCounter(DROPPED_EVENTS_METRIC, QUEUE_REASON_LABEL);
        }
        this.updateQueueMetric(queueCapacity, queueCapacity);
    }

    @Override
    public void eventDroppedAfterDequeue(ReportingEvent.ReportingEventType eventType) {
        Labels label;
        if (this.droppedEventsMetricEnabled && (label = this.getLabelFor(eventType)) != null) {
            this.metricRegistry.incrementCounter(DROPPED_EVENTS_METRIC, ERROR_REASON_LABEL);
        }
    }

    @Override
    public void requestFinished(ReportingEventCounter requestContent, long acceptedEventCount, long bytesWritten, boolean success) {
        Labels label;
        if (success) {
            label = SUCCESS_LABEL;
        } else {
            label = FAILURE_LABEL;
            if (this.droppedEventsMetricEnabled) {
                this.metricRegistry.addToCounter(DROPPED_EVENTS_METRIC, ERROR_REASON_LABEL, requestContent.getTotalCount() - acceptedEventCount);
            }
        }
        if (this.requestBytesMetricEnabled) {
            this.metricRegistry.addToCounter(REQUEST_BYTES_METRIC, label, bytesWritten);
        }
        if (this.requestCountMetricEnabled) {
            this.metricRegistry.incrementCounter(REQUEST_COUNT_METRIC, label);
        }
    }

    @Nullable
    private Labels getLabelFor(ReportingEvent.ReportingEventType type) {
        switch (type) {
            case TRANSACTION: {
                return TRANSACTION_LABEL;
            }
            case SPAN: {
                return SPAN_LABEL;
            }
            case ERROR: {
                return ERROR_LABEL;
            }
            case METRICSET_JSON_WRITER: {
                return METRICSET_LABEL;
            }
            case SHUTDOWN: 
            case END_REQUEST: 
            case MAKE_FLUSH_REQUEST: 
            case WAKEUP: {
                return null;
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)type));
    }

    private boolean anyQueueSizeMetricEnabled() {
        return this.maxQueueSizeMetricEnabled || this.minQueueSizeMetricEnabled;
    }
}

