/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics.builtin;

import co.elastic.apm.agent.configuration.MetricsConfiguration;
import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricCollector;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.metrics.MetricsProvider;
import co.elastic.apm.agent.util.ElasticThreadStateListener;
import co.elastic.apm.agent.util.ExecutorUtils;
import co.elastic.apm.agent.util.JmxUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentOverheadMetrics
extends AbstractLifecycleListener
implements ElasticThreadStateListener,
MetricsProvider {
    private static final Logger logger = LoggerFactory.getLogger(AgentOverheadMetrics.class);
    private static final String CPU_OVERHEAD_METRIC = "agent.background.cpu.overhead.pct";
    private static final String CPU_USAGE_METRIC = "agent.background.cpu.total.pct";
    private static final String ALLOCATION_METRIC = "agent.background.memory.allocation.bytes";
    private static final String THREAD_COUNT_METRIC = "agent.background.threads.count";
    private static final long NO_VALUE = -1L;
    private boolean cpuOverheadMetricEnabled;
    private boolean cpuUsageMetricEnabled;
    private boolean allocationMetricEnabled;
    private boolean threadCountMetricEnabled;
    private long lastReportedProcessCpuTime = -1L;
    private final ConcurrentHashMap<Thread, ThreadInfo> lastThreadInfo = new ConcurrentHashMap();
    private final ThreadMXBean threadBean;
    private final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    @Nullable
    private final Method isThreadAllocatedMemorySupported;
    @Nullable
    private final Method setThreadAllocatedMemoryEnabled;
    @Nullable
    private final Method getThreadAllocatedBytes;
    @Nullable
    private final Method getProcessCpuLoad = JmxUtils.getOperatingSystemMBeanMethod(this.osBean, "getProcessCpuLoad");
    @Nullable
    private final Method getProcessCpuTime = JmxUtils.getOperatingSystemMBeanMethod(this.osBean, "getProcessCpuTime");
    private final long processCpuTimeScalingFactor;

    public AgentOverheadMetrics() {
        this.threadBean = ManagementFactory.getThreadMXBean();
        this.isThreadAllocatedMemorySupported = JmxUtils.getThreadMBeanMethod(this.threadBean, "isThreadAllocatedMemorySupported", new Class[0]);
        this.setThreadAllocatedMemoryEnabled = JmxUtils.getThreadMBeanMethod(this.threadBean, "setThreadAllocatedMemoryEnabled", Boolean.TYPE);
        this.getThreadAllocatedBytes = JmxUtils.getThreadMBeanMethod(this.threadBean, "getThreadAllocatedBytes", Long.TYPE);
        this.processCpuTimeScalingFactor = JmxUtils.isIbmOperatingSystemMBean() && "true".equals(System.getProperty("com.ibm.lang.management.OperatingSystemMXBean.isCpuTime100ns")) ? 100L : 1L;
    }

    @Override
    public void start(ElasticApmTracer tracer) throws Exception {
        MetricRegistry metricRegistry = tracer.getMetricRegistry();
        MetricsConfiguration config = tracer.getConfig(MetricsConfiguration.class);
        this.bindTo(metricRegistry, config);
    }

    void bindTo(MetricRegistry metricRegistry, MetricsConfiguration config) {
        boolean allocationMeasurementEnabled;
        boolean overheadMetricsEnabled = config.isOverheadMetricsEnabled();
        this.cpuOverheadMetricEnabled = !metricRegistry.isDisabled(CPU_OVERHEAD_METRIC) && overheadMetricsEnabled;
        this.cpuUsageMetricEnabled = !metricRegistry.isDisabled(CPU_USAGE_METRIC) && overheadMetricsEnabled;
        this.allocationMetricEnabled = !metricRegistry.isDisabled(ALLOCATION_METRIC) && overheadMetricsEnabled;
        boolean bl = this.threadCountMetricEnabled = !metricRegistry.isDisabled(THREAD_COUNT_METRIC) && overheadMetricsEnabled;
        if (this.allocationMetricEnabled && !(allocationMeasurementEnabled = this.enableThreadAllocationMeasurement())) {
            this.allocationMetricEnabled = false;
        }
        if (this.cpuOverheadMetricEnabled || this.cpuUsageMetricEnabled) {
            boolean cpuTimeMeasurementEnabled;
            boolean bl2 = cpuTimeMeasurementEnabled = this.getProcessCpuTime() != -1L;
            if (!cpuTimeMeasurementEnabled) {
                logger.warn("Agent cpu overhead metrics can not be enabled: OperatingSystemMXBean.getProcessCpuTime() is not supported");
            }
            boolean bl3 = cpuTimeMeasurementEnabled = cpuTimeMeasurementEnabled && this.enableThreadCpuTimeMeasurement();
            if (!cpuTimeMeasurementEnabled) {
                this.cpuOverheadMetricEnabled = false;
                this.cpuUsageMetricEnabled = false;
            }
        }
        if (this.anyMetricEnabled()) {
            this.lastReportedProcessCpuTime = this.getProcessCpuTime();
            ExecutorUtils.setThreadStartListener(this);
            for (Map.Entry entry : ExecutorUtils.getStartedThreads()) {
                Thread thread = (Thread)entry.getKey();
                this.lastThreadInfo.putIfAbsent(thread, new ThreadInfo((String)entry.getValue()));
                ThreadInfo threadInfo = this.lastThreadInfo.get(thread);
                this.updateCpuTimeStat(thread, threadInfo);
                this.updateAllocationStat(thread, threadInfo);
            }
            metricRegistry.addMetricsProvider(this);
        }
    }

    private boolean enableThreadAllocationMeasurement() {
        if (this.isThreadAllocatedMemorySupported == null || this.setThreadAllocatedMemoryEnabled == null || this.getThreadAllocatedBytes == null) {
            logger.warn("Agent allocation metrics can not be enabled: The JVM ThreadBean does not expose this capability.");
            return false;
        }
        try {
            boolean isSupported = (Boolean)this.isThreadAllocatedMemorySupported.invoke((Object)this.threadBean, new Object[0]);
            if (!isSupported) {
                logger.warn("Agent allocation metrics can not be enabled: ThreadMxBean.isThreadAllocatedMemorySupported() returned false");
                return false;
            }
        }
        catch (Exception e) {
            logger.warn("Agent allocation metrics can not be enabled", e);
            return false;
        }
        try {
            this.setThreadAllocatedMemoryEnabled.invoke((Object)this.threadBean, true);
            logger.debug("Enabled agent allocation measurement");
        }
        catch (Exception e) {
            logger.warn("Agent allocation metrics can not be enabled", e);
            return false;
        }
        return true;
    }

    private boolean enableThreadCpuTimeMeasurement() {
        boolean isSupported = this.threadBean.isThreadCpuTimeSupported();
        if (!isSupported) {
            logger.warn("Agent cpu overhead metrics can not be enabled: ThreadMxBean.isThreadCpuTimeSupported() returned false");
            return false;
        }
        this.threadBean.setThreadCpuTimeEnabled(true);
        return true;
    }

    private boolean anyMetricEnabled() {
        return this.cpuOverheadMetricEnabled || this.cpuUsageMetricEnabled || this.allocationMetricEnabled || this.threadCountMetricEnabled;
    }

    @Override
    public void elasticThreadStarted(Thread thread, String purpose) {
        this.lastThreadInfo.putIfAbsent(thread, new ThreadInfo(purpose));
        ThreadInfo threadInfo = this.lastThreadInfo.get(thread);
        this.updateAllocationStat(thread, threadInfo);
        this.updateCpuTimeStat(thread, threadInfo);
    }

    @Override
    public void elasticThreadFinished(Thread thread) {
        ThreadInfo threadInfo = this.lastThreadInfo.get(thread);
        if (threadInfo != null) {
            if (this.cpuOverheadMetricEnabled || this.cpuUsageMetricEnabled) {
                threadInfo.deathCpuTime = this.getThreadCpuTime(thread);
            }
            if (this.allocationMetricEnabled) {
                threadInfo.deathAllocationBytes = this.getThreadAllocatedBytes(thread);
            }
        }
    }

    @Override
    public void collectAndReset(MetricCollector collector) {
        HashMap<String, AtomicLong> reusableCounters = new HashMap<String, AtomicLong>();
        this.collectCpuUsageMetrics(collector, reusableCounters);
        this.collectAllocationMetrics(collector, reusableCounters);
        this.collectActiveThreadsMetric(collector, reusableCounters);
        for (Map.Entry<Thread, ThreadInfo> threadInfo : this.lastThreadInfo.entrySet()) {
            Thread thread = threadInfo.getKey();
            if (thread.isAlive()) continue;
            this.lastThreadInfo.remove(thread);
        }
    }

    private void collectActiveThreadsMetric(MetricCollector collector, Map<String, AtomicLong> threadCountByPurpose) {
        if (!this.threadCountMetricEnabled) {
            return;
        }
        this.resetCounterMap(threadCountByPurpose);
        for (ThreadInfo threadInfo : this.lastThreadInfo.values()) {
            this.addToCounter(threadCountByPurpose, threadInfo.threadPurpose, 1L);
        }
        for (Map.Entry entry : threadCountByPurpose.entrySet()) {
            String purpose = (String)entry.getKey();
            long threadCount = ((AtomicLong)entry.getValue()).get();
            if (threadCount <= 0L) continue;
            Labels.Immutable labels = Labels.Mutable.of("task", purpose).immutableCopy();
            collector.addMetricValue(THREAD_COUNT_METRIC, labels, threadCount);
        }
    }

    private void collectAllocationMetrics(MetricCollector collector, Map<String, AtomicLong> allocatedBytesByPurpose) {
        if (!this.allocationMetricEnabled) {
            return;
        }
        this.resetCounterMap(allocatedBytesByPurpose);
        for (Map.Entry<Thread, ThreadInfo> entry : this.lastThreadInfo.entrySet()) {
            Thread thread = entry.getKey();
            ThreadInfo info = entry.getValue();
            String threadPurpose = info.threadPurpose;
            long allocationDelta = this.updateAllocationStat(thread, info);
            if (allocationDelta <= 0L) continue;
            this.addToCounter(allocatedBytesByPurpose, threadPurpose, allocationDelta);
        }
        for (Map.Entry<Object, Object> entry : allocatedBytesByPurpose.entrySet()) {
            String purpose = (String)entry.getKey();
            long allocationBytes = ((AtomicLong)entry.getValue()).get();
            if (allocationBytes <= 0L) continue;
            Labels.Immutable labels = Labels.Mutable.of("task", purpose).immutableCopy();
            collector.addMetricValue(ALLOCATION_METRIC, labels, allocationBytes);
        }
    }

    private void collectCpuUsageMetrics(MetricCollector collector, Map<String, AtomicLong> cpuTimeIncreaseByPurpose) {
        if (!this.cpuUsageMetricEnabled && !this.cpuOverheadMetricEnabled) {
            return;
        }
        this.resetCounterMap(cpuTimeIncreaseByPurpose);
        for (Map.Entry<Thread, ThreadInfo> threadInfo : this.lastThreadInfo.entrySet()) {
            Thread thread = threadInfo.getKey();
            ThreadInfo info = threadInfo.getValue();
            String threadPurpose = info.threadPurpose;
            long cpuTimeDelta = this.updateCpuTimeStat(thread, info);
            if (cpuTimeDelta <= 0L) continue;
            this.addToCounter(cpuTimeIncreaseByPurpose, threadPurpose, cpuTimeDelta);
        }
        long processCpuTimeDelta = this.getProcessCpuTimeDelta();
        if (processCpuTimeDelta == -1L) {
            return;
        }
        double processCpuUsage = this.getProcessCpuLoad();
        for (Map.Entry<String, AtomicLong> entry : cpuTimeIncreaseByPurpose.entrySet()) {
            String purpose = entry.getKey();
            double cpuOverhead = (double)entry.getValue().get() / (double)processCpuTimeDelta;
            if (!(cpuOverhead > 0.0)) continue;
            Labels.Immutable labels = Labels.Mutable.of("task", purpose).immutableCopy();
            if (this.cpuOverheadMetricEnabled) {
                collector.addMetricValue(CPU_OVERHEAD_METRIC, labels, cpuOverhead);
            }
            if (!this.cpuUsageMetricEnabled || processCpuUsage == -1.0) continue;
            collector.addMetricValue(CPU_USAGE_METRIC, labels, cpuOverhead * processCpuUsage);
        }
    }

    private void resetCounterMap(Map<String, AtomicLong> map) {
        for (Map.Entry<String, AtomicLong> entry : map.entrySet()) {
            entry.getValue().set(0L);
        }
    }

    private <K> void addToCounter(Map<K, AtomicLong> counterMap, K key, long increase) {
        AtomicLong counter = counterMap.get(key);
        if (counter != null) {
            counter.addAndGet(increase);
        } else {
            counterMap.put(key, new AtomicLong(increase));
        }
    }

    private long updateCpuTimeStat(Thread thread, ThreadInfo info) {
        if (!this.cpuUsageMetricEnabled && !this.cpuOverheadMetricEnabled) {
            return -1L;
        }
        long currentCpuTime = info.deathCpuTime != -1L ? info.deathCpuTime : this.getThreadCpuTime(thread);
        long delta = -1L;
        long lastCpuTime = info.cpuTime;
        if (currentCpuTime != -1L && lastCpuTime != -1L) {
            delta = currentCpuTime - lastCpuTime;
        }
        info.cpuTime = currentCpuTime;
        return delta;
    }

    private long updateAllocationStat(Thread thread, ThreadInfo info) {
        if (!this.allocationMetricEnabled) {
            return -1L;
        }
        long currentAllocation = info.deathAllocationBytes != -1L ? info.deathAllocationBytes : this.getThreadAllocatedBytes(thread);
        long delta = -1L;
        long lastAllocation = info.allocationBytes;
        if (currentAllocation != -1L && lastAllocation != -1L) {
            delta = currentAllocation - lastAllocation;
        }
        info.allocationBytes = currentAllocation;
        return delta;
    }

    private long getThreadAllocatedBytes(Thread thread) {
        if (this.getThreadAllocatedBytes == null) {
            return -1L;
        }
        try {
            long allocated = (Long)this.getThreadAllocatedBytes.invoke((Object)this.threadBean, thread.getId());
            if (allocated >= 0L) {
                return allocated;
            }
        }
        catch (Exception e) {
            logger.error("Error on attempt to fetch thread allocated bytes", e);
        }
        return -1L;
    }

    private long getThreadCpuTime(Thread thread) {
        long time = this.threadBean.getThreadCpuTime(thread.getId());
        if (time < 0L) {
            return -1L;
        }
        return time;
    }

    private long getProcessCpuTime() {
        if (this.getProcessCpuTime == null) {
            return -1L;
        }
        try {
            long cpuTime = (Long)this.getProcessCpuTime.invoke((Object)this.osBean, new Object[0]);
            if (cpuTime >= 0L) {
                return cpuTime * this.processCpuTimeScalingFactor;
            }
        }
        catch (Exception e) {
            logger.error("Error on attempt to fetch process cpu time", e);
        }
        return -1L;
    }

    private long getProcessCpuTimeDelta() {
        long processCpuTimeDelta = -1L;
        long currentProcessCpuTime = this.getProcessCpuTime();
        if (currentProcessCpuTime != -1L && this.lastReportedProcessCpuTime != -1L) {
            processCpuTimeDelta = currentProcessCpuTime - this.lastReportedProcessCpuTime;
        }
        this.lastReportedProcessCpuTime = currentProcessCpuTime;
        return processCpuTimeDelta;
    }

    double getProcessCpuLoad() {
        if (this.getProcessCpuLoad == null) {
            return -1.0;
        }
        try {
            double cpuLoad = (Double)this.getProcessCpuLoad.invoke((Object)this.osBean, new Object[0]);
            if (cpuLoad >= 0.0) {
                return cpuLoad;
            }
        }
        catch (Exception e) {
            logger.error("Error on attempt to fetch process cpu load", e);
        }
        return -1.0;
    }

    private static class ThreadInfo {
        final String threadPurpose;
        volatile long cpuTime = -1L;
        volatile long allocationBytes = -1L;
        volatile long deathCpuTime = -1L;
        volatile long deathAllocationBytes = -1L;

        private ThreadInfo(String threadPurpose) {
            this.threadPurpose = threadPurpose;
        }
    }
}

