/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics;

import co.elastic.apm.agent.metrics.DoubleSupplier;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.Timer;
import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class MetricSet
implements Recyclable {
    private final Labels.Immutable labels;
    private final ConcurrentMap<String, DoubleSupplier> gauges;
    private final ConcurrentMap<String, Timer> timers = new ConcurrentHashMap<String, Timer>(32, 0.5f, Runtime.getRuntime().availableProcessors());
    private final ConcurrentMap<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>(32, 0.5f, Runtime.getRuntime().availableProcessors());
    private final ConcurrentMap<String, Double> rawValues = new ConcurrentHashMap<String, Double>();
    private volatile boolean hasNonEmptyTimer;
    private volatile boolean hasNonEmptyCounter;

    MetricSet(Labels.Immutable labels) {
        this(labels, new ConcurrentHashMap<String, DoubleSupplier>());
    }

    MetricSet(Labels.Immutable labels, ConcurrentMap<String, DoubleSupplier> gauges) {
        this.labels = labels;
        this.gauges = gauges;
    }

    void addGauge(String name, DoubleSupplier metric) {
        this.gauges.putIfAbsent(name, metric);
    }

    @Nullable
    DoubleSupplier getGauge(String name) {
        return (DoubleSupplier)this.gauges.get(name);
    }

    public Labels getLabels() {
        return this.labels;
    }

    public ConcurrentMap<String, DoubleSupplier> getGauges() {
        return this.gauges;
    }

    public void addRawMetric(String metric, double value) {
        this.rawValues.put(metric, value);
    }

    public Timer timer(String timerName) {
        this.hasNonEmptyTimer = true;
        Timer timer = (Timer)this.timers.get(timerName);
        if (timer == null) {
            this.timers.putIfAbsent(timerName, new Timer());
            timer = (Timer)this.timers.get(timerName);
        }
        return timer;
    }

    public void addToCounter(String name, long count) {
        this.hasNonEmptyCounter = true;
        AtomicLong counter = (AtomicLong)this.counters.get(name);
        if (counter == null) {
            this.counters.putIfAbsent(name, new AtomicLong());
            counter = (AtomicLong)this.counters.get(name);
        }
        counter.addAndGet(count);
    }

    public Map<String, Timer> getTimers() {
        return this.timers;
    }

    public boolean hasContent() {
        return !this.gauges.isEmpty() || this.hasNonEmptyTimer || this.hasNonEmptyCounter || !this.rawValues.isEmpty();
    }

    @Override
    public void resetState() {
        for (Timer timer : this.timers.values()) {
            timer.resetState();
        }
        for (AtomicLong counter : this.counters.values()) {
            counter.set(0L);
        }
        this.rawValues.clear();
        this.hasNonEmptyTimer = false;
        this.hasNonEmptyCounter = false;
    }

    public Map<String, AtomicLong> getCounters() {
        return this.counters;
    }

    public Map<String, Double> getRawMetrics() {
        return this.rawValues;
    }
}

