/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.loginstr.reformatting;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServerlessConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.metadata.Service;
import co.elastic.apm.agent.impl.metadata.ServiceFactory;
import co.elastic.apm.agent.logging.LogEcsReformatting;
import co.elastic.apm.agent.logging.LoggingConfiguration;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.sdk.state.CallDepth;
import co.elastic.apm.agent.sdk.state.GlobalState;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakConcurrent;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@GlobalState
public abstract class AbstractEcsReformattingHelper<A, F> {
    private static final String ECS_LOGGING_PACKAGE_NAME = "co.elastic.logging";
    private static final Logger logger = LoggerFactory.getLogger(AbstractEcsReformattingHelper.class);
    public static final String ECS_SHADE_APPENDER_NAME = "EcsShadeAppender";
    private static final Object NULL_APPENDER = new Object();
    private static final Object NULL_FORMATTER = new Object();
    private static final CallDepth callDepth = CallDepth.get(AbstractEcsReformattingHelper.class);
    private static final WeakMap<Object, Object> originalAppender2ecsAppender = WeakConcurrent.buildMap();
    private static final WeakMap<Object, Object> originalAppender2originalFormatter = WeakConcurrent.buildMap();
    private static final WeakMap<Object, Object> originalAppender2ecsFormatter = WeakConcurrent.buildMap();
    private static final ThreadLocal<LogEcsReformatting> configForCurrentLogEvent = new ThreadLocal();
    private final LoggingConfiguration loggingConfiguration;
    @Nullable
    private final String globalServiceName;
    @Nullable
    private final String globalServiceVersion;
    @Nullable
    private final String configuredServiceNodeName;
    @Nullable
    private final Map<String, String> additionalFields;

    public AbstractEcsReformattingHelper() {
        ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();
        this.loggingConfiguration = tracer.getConfig(LoggingConfiguration.class);
        this.additionalFields = this.loggingConfiguration.getLogEcsReformattingAdditionalFields();
        Service service = new ServiceFactory().createService(tracer.getConfig(CoreConfiguration.class), "", tracer.getConfig(ServerlessConfiguration.class));
        this.globalServiceName = service.getName();
        this.globalServiceVersion = service.getVersion();
        this.configuredServiceNodeName = service.getNode() != null ? service.getNode().getName() : null;
    }

    public boolean onAppendEnter(A appender) {
        if (callDepth.isNestedCallAndIncrement()) {
            return false;
        }
        LogEcsReformatting reformattingConfig = this.loggingConfiguration.getLogEcsReformatting();
        configForCurrentLogEvent.set(reformattingConfig);
        boolean currentlyOverriding = originalAppender2originalFormatter.containsKey(appender);
        if (reformattingConfig == LogEcsReformatting.OVERRIDE) {
            if (!currentlyOverriding) {
                this.startOverriding(appender);
            }
        } else {
            if (currentlyOverriding) {
                this.stopOverriding(appender);
            }
            if (reformattingConfig == LogEcsReformatting.SHADE || reformattingConfig == LogEcsReformatting.REPLACE) {
                Object ecsAppender = originalAppender2ecsAppender.get(appender);
                if (ecsAppender == null) {
                    ecsAppender = this.createAndMapShadeAppenderFor(appender);
                }
                return reformattingConfig == LogEcsReformatting.REPLACE && ecsAppender != NULL_APPENDER;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startOverriding(A originalAppender) {
        WeakMap<Object, Object> weakMap = originalAppender2originalFormatter;
        synchronized (weakMap) {
            if (originalAppender2originalFormatter.containsKey(originalAppender)) {
                return;
            }
            Object mappedFormatter = NULL_FORMATTER;
            Object ecsFormatter = NULL_FORMATTER;
            try {
                if (this.shouldApplyEcsReformatting(originalAppender)) {
                    F originalFormatter = this.getFormatterFrom(originalAppender);
                    mappedFormatter = originalFormatter;
                    String serviceName = this.getServiceName();
                    F createdEcsFormatter = this.createEcsFormatter(this.getEventDataset(originalAppender, serviceName), serviceName, this.getServiceVersion(), this.configuredServiceNodeName, this.additionalFields, originalFormatter);
                    this.setFormatter(originalAppender, createdEcsFormatter);
                    ecsFormatter = createdEcsFormatter;
                }
            }
            catch (Throwable throwable) {
                logger.warn(String.format("Failed to replace formatter for log appender %s.%s. Log events for this appender will not be overridden.", originalAppender.getClass().getName(), this.getAppenderName(originalAppender)), throwable);
            }
            finally {
                originalAppender2ecsFormatter.put(originalAppender, ecsFormatter);
                originalAppender2originalFormatter.put(originalAppender, mappedFormatter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopOverriding(A appender) {
        WeakMap<Object, Object> weakMap = originalAppender2originalFormatter;
        synchronized (weakMap) {
            Object originalFormatter = originalAppender2originalFormatter.remove(appender);
            if (originalFormatter != null && originalFormatter != NULL_FORMATTER) {
                try {
                    this.setFormatter(appender, originalFormatter);
                }
                catch (Throwable throwable) {
                    logger.warn(String.format("Failed to replace formatter for log appender %s.%s. Log events for this appender are overridden with ECS-formatted events.", appender.getClass().getName(), this.getAppenderName(appender)), throwable);
                }
            }
            originalAppender2ecsFormatter.remove(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public A onAppendExit(A appender) {
        if (callDepth.isNestedCallAndDecrement()) {
            return null;
        }
        Object ecsAppender = null;
        try {
            Object mappedAppender;
            LogEcsReformatting logEcsReformatting = configForCurrentLogEvent.get();
            if ((logEcsReformatting == LogEcsReformatting.SHADE || logEcsReformatting == LogEcsReformatting.REPLACE) && (mappedAppender = originalAppender2ecsAppender.get(appender)) != null && mappedAppender != NULL_APPENDER) {
                ecsAppender = mappedAppender;
            }
        }
        finally {
            configForCurrentLogEvent.remove();
        }
        return (A)ecsAppender;
    }

    @Nullable
    protected String getConfiguredReformattingDir() {
        return this.loggingConfiguration.getLogEcsFormattingDestinationDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createAndMapShadeAppenderFor(A originalAppender) {
        WeakMap<Object, Object> weakMap = originalAppender2ecsAppender;
        synchronized (weakMap) {
            Object ecsAppender = originalAppender2ecsAppender.get(originalAppender);
            if (ecsAppender != null) {
                return ecsAppender;
            }
            ecsAppender = NULL_APPENDER;
            try {
                String serviceName;
                F ecsFormatter;
                if (this.shouldApplyEcsReformatting(originalAppender) && (ecsAppender = this.createAndStartEcsAppender(originalAppender, ECS_SHADE_APPENDER_NAME, ecsFormatter = this.createEcsFormatter(this.getEventDataset(originalAppender, serviceName = this.getServiceName()), serviceName, this.getServiceVersion(), this.configuredServiceNodeName, this.additionalFields, this.getFormatterFrom(originalAppender)))) == null) {
                    ecsAppender = NULL_APPENDER;
                }
            }
            catch (Throwable throwable) {
                logger.warn(String.format("Failed to create ECS shade appender for log appender %s.%s. Log events for this appender will not be shaded.", originalAppender.getClass().getName(), this.getAppenderName(originalAppender)), throwable);
            }
            finally {
                originalAppender2ecsAppender.put(originalAppender, ecsAppender);
            }
            return ecsAppender;
        }
    }

    private boolean shouldApplyEcsReformatting(A originalAppender) {
        F formatter = this.getFormatterFrom(originalAppender);
        return formatter != null && !this.isShadingAppender(originalAppender) && !this.isEcsFormatter(formatter) && this.isAllowedFormatter(formatter, this.loggingConfiguration.getLogEcsFormatterAllowList());
    }

    protected boolean isAllowedFormatter(F formatter, List<WildcardMatcher> allowList) {
        return WildcardMatcher.anyMatch(allowList, formatter.getClass().getName()) != null;
    }

    @Nullable
    public F getEcsOverridingFormatterFor(A originalAppender) {
        Object mappedFormatter;
        Object ecsFormatter = null;
        if (configForCurrentLogEvent.get() == LogEcsReformatting.OVERRIDE && (mappedFormatter = originalAppender2ecsFormatter.get(originalAppender)) != null && mappedFormatter != NULL_FORMATTER) {
            ecsFormatter = mappedFormatter;
        }
        return (F)ecsFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeShadeAppenderFor(A originalAppender) {
        WeakMap<Object, Object> weakMap = originalAppender2ecsAppender;
        synchronized (weakMap) {
            Object shadeAppender = originalAppender2ecsAppender.remove(originalAppender);
            if (shadeAppender != null && shadeAppender != NULL_APPENDER) {
                this.closeShadeAppender(shadeAppender);
            }
        }
    }

    private boolean isShadingAppender(A appender) {
        return this.getAppenderName(appender) == ECS_SHADE_APPENDER_NAME;
    }

    private boolean isEcsFormatter(F formatter) {
        return formatter.getClass().getName().startsWith(ECS_LOGGING_PACKAGE_NAME);
    }

    @Nullable
    protected abstract F getFormatterFrom(A var1);

    protected abstract void setFormatter(A var1, F var2);

    @Nullable
    protected abstract String getAppenderName(A var1);

    @Nullable
    protected abstract A createAndStartEcsAppender(A var1, String var2, F var3);

    @Nullable
    protected abstract F createEcsFormatter(String var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable Map<String, String> var5, F var6);

    @Nullable
    private String getServiceName() {
        return this.globalServiceName;
    }

    @Nullable
    private String getServiceVersion() {
        return this.globalServiceVersion;
    }

    private String getEventDataset(A appender, @Nullable String serviceName) {
        String appenderName = this.getAppenderName(appender);
        if (appenderName == null) {
            appenderName = "log";
        }
        if (serviceName == null) {
            return appenderName;
        }
        return serviceName + "." + appenderName;
    }

    protected long getMaxLogFileSize() {
        return this.loggingConfiguration.getLogFileSize();
    }

    protected long getDefaultMaxLogFileSize() {
        return this.loggingConfiguration.getDefaultLogFileSize();
    }

    protected abstract void closeShadeAppender(A var1);
}

