/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.loginstr.error;

import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.sdk.state.CallDepth;
import co.elastic.apm.agent.util.PrivilegedActionUtils;
import javax.annotation.Nullable;

public class LoggerErrorHelper {
    private final CallDepth callDepth;
    private final Tracer tracer;

    public LoggerErrorHelper(Class<?> adviceClass, Tracer tracer) {
        this.callDepth = CallDepth.get(adviceClass);
        this.tracer = tracer;
    }

    @Nullable
    public Object enter(@Nullable Throwable exception, Class<?> originClass) {
        if (!this.callDepth.isNestedCallAndIncrement() && exception != null) {
            ErrorCapture error = this.tracer.captureException(exception, this.tracer.getActive(), PrivilegedActionUtils.getClassLoader(originClass));
            if (error != null) {
                error.activate();
            }
            return error;
        }
        return null;
    }

    public void exit(@Nullable Object errorCapture) {
        this.callDepth.decrement();
        if (errorCapture instanceof ErrorCapture) {
            ErrorCapture error = (ErrorCapture)errorCapture;
            error.deactivate().end();
        }
    }
}

