/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logging;

import co.elastic.apm.agent.configuration.converter.ByteValue;
import co.elastic.apm.agent.configuration.converter.ByteValueConverter;
import co.elastic.apm.agent.logging.Log4j2ConfigurationFactory;
import co.elastic.apm.agent.logging.Log4jLoggerFactoryBridge;
import co.elastic.apm.agent.logging.LogEcsReformatting;
import co.elastic.apm.agent.logging.LogFormat;
import co.elastic.apm.agent.logging.LogLevel;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcherValueConverter;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;
import org.stagemonitor.configuration.converter.ListValueConverter;
import org.stagemonitor.configuration.converter.MapValueConverter;
import org.stagemonitor.configuration.converter.StringValueConverter;
import org.stagemonitor.configuration.source.ConfigurationSource;

public class LoggingConfiguration
extends ConfigurationOptionProvider {
    public static final String SYSTEM_OUT = "System.out";
    static final String LOG_LEVEL_KEY = "log_level";
    static final String LOG_FILE_KEY = "log_file";
    static final String LOG_FILE_SIZE_KEY = "log_file_size";
    static final String DEFAULT_LOG_FILE = "System.out";
    private static final String LOGGING_CATEGORY = "Logging";
    public static final String AGENT_HOME_PLACEHOLDER = "_AGENT_HOME_";
    static final String DEPRECATED_LOG_LEVEL_KEY = "logging.log_level";
    static final String DEPRECATED_LOG_FILE_KEY = "logging.log_file";
    public static final String DEFAULT_MAX_SIZE = "50mb";
    static final String LOG_FORMAT_SOUT_KEY = "log_format_sout";
    public static final String LOG_FORMAT_FILE_KEY = "log_format_file";
    static final String INITIAL_LISTENERS_LEVEL = "log4j2.StatusLogger.level";
    static final String INITIAL_STATUS_LOGGER_LEVEL = "org.apache.logging.log4j.simplelog.StatusLogger.level";
    static final String DEFAULT_LISTENER_LEVEL = "Log4jDefaultStatusLevel";
    public ConfigurationOption<LogLevel> logLevel = ConfigurationOption.enumOption(LogLevel.class).key("log_level").aliasKeys("logging.log_level").configurationCategory("Logging").description("Sets the logging level for the agent.\nThis option is case-insensitive.\n\nNOTE: `CRITICAL` is a valid option, but it is mapped to `ERROR`; `WARN` and `WARNING` are equivalent; \n`OFF` is only available since version 1.16.0").dynamic(true).addChangeListener(new ConfigurationOption.ChangeListener<LogLevel>(){

        @Override
        public void onChange(ConfigurationOption<?> configurationOption, LogLevel oldValue, LogLevel newValue) {
            newValue = LoggingConfiguration.mapLogLevel(newValue);
            LoggingConfiguration.setLogLevel(newValue);
        }
    }).buildWithDefault(LogLevel.INFO);
    public ConfigurationOption<String> logFile = ConfigurationOption.stringOption().key("log_file").aliasKeys("logging.log_file").configurationCategory("Logging").description("Sets the path of the agent logs.\nThe special value `_AGENT_HOME_` is a placeholder for the folder the elastic-apm-agent.jar is in.\nExample: `_AGENT_HOME_/logs/elastic-apm.log`\n\nWhen set to the special value 'System.out',\nthe logs are sent to standard out.\n\nNOTE: When logging to a file,\nthe log will be formatted in new-line-delimited JSON.\nWhen logging to std out, the log will be formatted as plain-text.").dynamic(false).buildWithDefault("System.out");
    private final ConfigurationOption<LogEcsReformatting> logEcsReformatting = ConfigurationOption.enumOption(LogEcsReformatting.class).key("log_ecs_reformatting").configurationCategory("Logging").tags("added[1.22.0]", "experimental").description("Specifying whether and how the agent should automatically reformat application logs \ninto {ecs-logging-ref}/intro.html[ECS-compatible JSON], suitable for ingestion into Elasticsearch for \nfurther Log analysis. This functionality is available for log4j1, log4j2, Logback and `java.util.logging`. \nThe ECS log lines will include active trace/transaction/error IDs, if there are such. \n\nThis option only applies to pattern layouts/formatters by default.\nSee also <<config-log-ecs-formatter-allow-list, `log_ecs_formatter_allow_list`>>.\nTo properly ingest and parse ECS JSON logs, follow the {ecs-logging-java-ref}/setup.html#setup-step-2[getting started guide].\n\nAvailable options:\n\n - OFF - application logs are not reformatted. \n - SHADE - agent logs are reformatted and \"shade\" ECS-JSON-formatted logs are automatically created in \n   addition to the original application logs. Shade logs will have the same name as the original logs, \n   but with the \".ecs.json\" extension instead of the original extension. Destination directory for the \n   shade logs can be configured through the <<config-log-ecs-reformatting-dir,`log_ecs_reformatting_dir`>> \n   configuration. Shade logs do not inherit file-rollover strategy from the original logs. Instead, they \n   use their own size-based rollover strategy according to the <<config-log-file-size, `log_file_size`>> \n   configuration and while allowing maximum of two shade log files.\n - REPLACE - similar to `SHADE`, but the original logs will not be written. This option is useful if \n   you wish to maintain similar logging-related overhead, but write logs to a different location and/or \n   with a different file extension.\n - OVERRIDE - same log output is used, but in ECS-compatible JSON format instead of the original format. \n\nNOTE: while `SHADE` and `REPLACE` options are only relevant to file log appenders, the `OVERRIDE` option \nis also valid for other appenders, like System out and console.\n").dynamic(true).buildWithDefault(LogEcsReformatting.OFF);
    private final ConfigurationOption<Map<String, String>> logEcsReformattingAdditionalFields = ConfigurationOption.builder(new MapValueConverter<String, String>(StringValueConverter.INSTANCE, StringValueConverter.INSTANCE, "=", ","), Map.class).key("log_ecs_reformatting_additional_fields").tags("added[1.26.0]").configurationCategory("Logging").description("A comma-separated list of key-value pairs that will be added as additional fields to all log events.\n Takes the format `key=value[,key=value[,...]]`, for example: `key1=value1,key2=value2`.\n Only relevant if <<config-log-ecs-reformatting,`log_ecs_reformatting`>> is set to any option other than `OFF`.\n").dynamic(false).buildWithDefault(Collections.emptyMap());
    private final ConfigurationOption<List<WildcardMatcher>> logEcsFormatterAllowList = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("log_ecs_formatter_allow_list").configurationCategory("Logging").description("Only formatters that match an item on this list will be automatically reformatted to ECS when \n<<config-log-ecs-reformatting,`log_ecs_reformatting`>> is set to any option other than `OFF`. \nA formatter is the logging-framework-specific entity that is responsible for the formatting \nof log events. For example, in log4j it would be a `Layout` implementation, whereas in Logback it would \nbe an `Encoder` implementation. \n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(false).buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("*PatternLayout*"), WildcardMatcher.valueOf("org.apache.log4j.SimpleLayout"), WildcardMatcher.valueOf("ch.qos.logback.core.encoder.EchoEncoder"), WildcardMatcher.valueOf("java.util.logging.SimpleFormatter"), WildcardMatcher.valueOf("org.apache.juli.OneLineFormatter"), WildcardMatcher.valueOf("org.springframework.boot.logging.java.SimpleFormatter")));
    private final ConfigurationOption<String> logEcsFormattingDestinationDir = ConfigurationOption.stringOption().key("log_ecs_reformatting_dir").configurationCategory("Logging").description("If <<config-log-ecs-reformatting,`log_ecs_reformatting`>> is set to `SHADE` or `REPLACE`, \nthe shade log files will be written alongside the original logs in the same directory by default. \nUse this configuration in order to write the shade logs into an alternative destination. Omitting this \nconfig or setting it to an empty string will restore the default behavior. If relative path is used, \nthis path will be used relative to the original logs directory.").dynamic(false).buildWithDefault("");
    public ConfigurationOption<ByteValue> logFileSize = ByteValueConverter.byteOption().key("log_file_size").configurationCategory("Logging").description("The size of the log file.\n\nThe agent always keeps one history file so that the max total log file size is twice the value of this setting.\n").dynamic(false).tags("added[1.17.0]").buildWithDefault(ByteValue.of("50mb"));
    public ConfigurationOption<LogFormat> logFormatSout = ConfigurationOption.enumOption(LogFormat.class).key("log_format_sout").configurationCategory("Logging").description("Defines the log format when logging to `System.out`.\n\nWhen set to `JSON`, the agent will format the logs in an https://github.com/elastic/ecs-logging-java[ECS-compliant JSON format]\nwhere each log event is serialized as a single line.").tags("added[1.17.0]").buildWithDefault(LogFormat.PLAIN_TEXT);
    public ConfigurationOption<LogFormat> logFormatFile = ConfigurationOption.enumOption(LogFormat.class).key("log_format_file").configurationCategory("Logging").description("Defines the log format when logging to a file.\n\nWhen set to `JSON`, the agent will format the logs in an https://github.com/elastic/ecs-logging-java[ECS-compliant JSON format]\nwhere each log event is serialized as a single line.\n").tags("added[1.17.0]").buildWithDefault(LogFormat.PLAIN_TEXT);

    @Nonnull
    static LogLevel mapLogLevel(LogLevel original) {
        LogLevel mapped = original;
        if (original == LogLevel.WARNING) {
            mapped = LogLevel.WARN;
        } else if (original == LogLevel.CRITICAL) {
            mapped = LogLevel.ERROR;
        }
        return mapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(List<ConfigurationSource> sources, String ephemeralId) {
        String initialListenersLevel = System.setProperty(INITIAL_LISTENERS_LEVEL, "OFF");
        String initialStatusLoggerLevel = System.setProperty(INITIAL_STATUS_LOGGER_LEVEL, "OFF");
        String defaultListenerLevel = System.setProperty(DEFAULT_LISTENER_LEVEL, "OFF");
        try {
            ConfigurationFactory.setConfigurationFactory(new Log4j2ConfigurationFactory(sources, ephemeralId));
            LoggerFactory.initialize(new Log4jLoggerFactoryBridge());
        }
        catch (Throwable throwable) {
            System.err.println("[elastic-apm-agent] ERROR Failure during initialization of agent's log4j system: " + throwable.getMessage());
        }
        finally {
            LoggingConfiguration.restoreSystemProperty(INITIAL_LISTENERS_LEVEL, initialListenersLevel);
            LoggingConfiguration.restoreSystemProperty(INITIAL_STATUS_LOGGER_LEVEL, initialStatusLoggerLevel);
            LoggingConfiguration.restoreSystemProperty(DEFAULT_LISTENER_LEVEL, defaultListenerLevel);
            StatusLogger.getLogger().setLevel(Level.ERROR);
        }
    }

    public static void shutdown() {
        Log4jLoggerFactoryBridge.shutdown();
    }

    private static void restoreSystemProperty(String key, @Nullable String originalValue) {
        if (originalValue != null) {
            System.setProperty(key, originalValue);
        } else {
            System.clearProperty(key);
        }
    }

    public String getLogFile() {
        return this.logFile.get();
    }

    private static void setLogLevel(@Nullable LogLevel level) {
        if (level == null) {
            level = LogLevel.INFO;
        }
        Level log4jLevel = Level.toLevel(level.toString(), Level.INFO);
        LoggerContextFactory contextFactory = LogManager.getFactory();
        if (contextFactory instanceof Log4jContextFactory) {
            ContextSelector selector = ((Log4jContextFactory)contextFactory).getSelector();
            for (LoggerContext loggerContext : selector.getLoggerContexts()) {
                LoggerConfig loggerConfig = loggerContext.getConfiguration().getRootLogger();
                if (loggerConfig.getLevel().equals(log4jLevel)) continue;
                loggerConfig.setLevel(log4jLevel);
                loggerContext.updateLoggers();
            }
        } else {
            LoggerFactory.getLogger(LoggingConfiguration.class).warn("Unexpected type of LoggerContextFactory - {}, cannot update logging level", (Object)contextFactory);
        }
        Configurator.setLevel("com.networknt.schema", Level.WARN);
    }

    public LogEcsReformatting getLogEcsReformatting() {
        return this.logEcsReformatting.get();
    }

    public Map<String, String> getLogEcsReformattingAdditionalFields() {
        return this.logEcsReformattingAdditionalFields.get();
    }

    public List<WildcardMatcher> getLogEcsFormatterAllowList() {
        return this.logEcsFormatterAllowList.get();
    }

    @Nullable
    public String getLogEcsFormattingDestinationDir() {
        String logReformattingDestDir = this.logEcsFormattingDestinationDir.get().trim();
        return logReformattingDestDir.isEmpty() ? null : logReformattingDestDir;
    }

    public long getLogFileSize() {
        return this.logFileSize.get().getBytes();
    }

    public long getDefaultLogFileSize() {
        return this.logFileSize.getValueConverter().convert(this.logFileSize.getDefaultValueAsString()).getBytes();
    }
}

