/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logging;

import co.elastic.apm.agent.sdk.logging.Logger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4j2LoggerBridge
implements Logger {
    public static final String FQCN = Log4j2LoggerBridge.class.getName();
    private final ExtendedLogger log4jLogger;
    private final String name;

    public Log4j2LoggerBridge(ExtendedLogger log4jLogger, String name) {
        this.log4jLogger = log4jLogger;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void trace(String format) {
        this.logIfEnabled(Level.TRACE, format);
    }

    @Override
    public void trace(String format, Object o) {
        this.logIfEnabled(Level.TRACE, format, o);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.logIfEnabled(Level.TRACE, format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... args) {
        this.logIfEnabled(Level.TRACE, format, args);
    }

    @Override
    public void trace(String format, Throwable t) {
        this.logIfEnabled(Level.TRACE, format, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void debug(String format) {
        this.logIfEnabled(Level.DEBUG, format);
    }

    @Override
    public void debug(String format, Object o) {
        this.logIfEnabled(Level.DEBUG, format, o);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.logIfEnabled(Level.DEBUG, format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... args) {
        this.logIfEnabled(Level.DEBUG, format, args);
    }

    @Override
    public void debug(String format, Throwable t) {
        this.logIfEnabled(Level.DEBUG, format, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public void info(String format) {
        this.logIfEnabled(Level.INFO, format);
    }

    @Override
    public void info(String format, Object o) {
        this.logIfEnabled(Level.INFO, format, o);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.logIfEnabled(Level.INFO, format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... args) {
        this.logIfEnabled(Level.INFO, format, args);
    }

    @Override
    public void info(String format, Throwable t) {
        this.logIfEnabled(Level.INFO, format, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public void warn(String format) {
        this.logIfEnabled(Level.WARN, format);
    }

    @Override
    public void warn(String format, Object o) {
        this.logIfEnabled(Level.WARN, format, o);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.logIfEnabled(Level.WARN, format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.logIfEnabled(Level.WARN, format, args);
    }

    @Override
    public void warn(String format, Throwable t) {
        this.logIfEnabled(Level.WARN, format, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public void error(String format) {
        this.logIfEnabled(Level.ERROR, format);
    }

    @Override
    public void error(String format, Object o) {
        this.logIfEnabled(Level.ERROR, format, o);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.logIfEnabled(Level.ERROR, format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... args) {
        this.logIfEnabled(Level.ERROR, format, args);
    }

    @Override
    public void error(String format, Throwable t) {
        this.logIfEnabled(Level.ERROR, format, t);
    }

    private void logIfEnabled(final Level level, final String format) {
        if (System.getSecurityManager() == null) {
            this.log4jLogger.logIfEnabled(FQCN, level, null, format);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log4j2LoggerBridge.this.log4jLogger.logIfEnabled(FQCN, level, null, format);
                return null;
            }
        });
    }

    private void logIfEnabled(final Level level, final String format, final Throwable t) {
        if (System.getSecurityManager() == null) {
            this.log4jLogger.logIfEnabled(FQCN, level, (Marker)null, format, t);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log4j2LoggerBridge.this.log4jLogger.logIfEnabled(FQCN, level, (Marker)null, format, t);
                return null;
            }
        });
    }

    private void logIfEnabled(final Level level, final String format, final Object ... params) {
        if (System.getSecurityManager() == null) {
            this.log4jLogger.logIfEnabled(FQCN, level, (Marker)null, format, params);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log4j2LoggerBridge.this.log4jLogger.logIfEnabled(FQCN, level, (Marker)null, format, params);
                return null;
            }
        });
    }

    private void logIfEnabled(final Level level, final String format, final Object arg) {
        if (System.getSecurityManager() == null) {
            this.log4jLogger.logIfEnabled(FQCN, level, (Marker)null, format, arg);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log4j2LoggerBridge.this.log4jLogger.logIfEnabled(FQCN, level, (Marker)null, format, arg);
                return null;
            }
        });
    }

    private void logIfEnabled(final Level level, final String format, final Object arg1, final Object arg2) {
        if (System.getSecurityManager() == null) {
            this.log4jLogger.logIfEnabled(FQCN, level, (Marker)null, format, arg1, arg2);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log4j2LoggerBridge.this.log4jLogger.logIfEnabled(FQCN, level, (Marker)null, format, arg1, arg2);
                return null;
            }
        });
    }

    private boolean isEnabled(Level level) {
        return this.log4jLogger.isEnabled(level, null, null);
    }
}

