/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logback.reformatting;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;

class VersionUtils {
    @Nullable
    private static MethodHandle setMaxSizeStringMethod;
    @Nullable
    private static MethodHandle setMaxSizeFileSizeMethod;
    @Nullable
    private static MethodHandle isImmediateFlushMethod;
    @Nullable
    private static MethodHandle setImmediateFlushMethod;

    VersionUtils() {
    }

    static void setMaxFileSize(SizeBasedTriggeringPolicy<?> policy, long maxFileSize) throws Throwable {
        if (maxFileSize > 0L) {
            String fileSizeStr = String.valueOf(maxFileSize);
            if (setMaxSizeFileSizeMethod != null) {
                FileSize fileSize = FileSize.valueOf((String)fileSizeStr);
                setMaxSizeFileSizeMethod.invoke(policy, fileSize);
            } else if (setMaxSizeStringMethod != null) {
                setMaxSizeStringMethod.invoke(policy, fileSizeStr);
            }
        } else {
            throw new IllegalStateException("Invalid max size of file bytes - " + maxFileSize);
        }
    }

    static void copyImmediateFlushSetting(OutputStreamAppender<?> originalAppender, OutputStreamAppender<?> ecsAppender) throws Throwable {
        if (setImmediateFlushMethod != null && isImmediateFlushMethod != null) {
            boolean immediateFlushSet = isImmediateFlushMethod.invoke(originalAppender);
            setImmediateFlushMethod.invoke(ecsAppender, immediateFlushSet);
        }
    }

    static {
        try {
            try {
                setMaxSizeFileSizeMethod = MethodHandles.lookup().findVirtual(SizeBasedTriggeringPolicy.class, "setMaxFileSize", MethodType.methodType(Void.TYPE, FileSize.class));
            }
            catch (NoSuchMethodException e) {
                setMaxSizeStringMethod = MethodHandles.lookup().findVirtual(SizeBasedTriggeringPolicy.class, "setMaxFileSize", MethodType.methodType(Void.TYPE, String.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            isImmediateFlushMethod = MethodHandles.lookup().findVirtual(OutputStreamAppender.class, "isImmediateFlush", MethodType.methodType(Boolean.TYPE));
            setImmediateFlushMethod = MethodHandles.lookup().findVirtual(OutputStreamAppender.class, "setImmediateFlush", MethodType.methodType(Void.TYPE, Boolean.TYPE));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

