/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log4j2.correlation;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.log4j2.correlation.Log4j2_6LogCorrelationHelper;
import co.elastic.apm.agent.log4j2.correlation.Log4j2_7PlusLogCorrelationHelper;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class Log4j2LogCorrelationInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("log4j2-correlation");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(ElementMatchers.not(CustomElementMatchers.isAgentClassLoader())).and(CustomElementMatchers.classLoaderCanLoadClass("org.apache.logging.log4j.core.impl.LogEventFactory"));
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameEndsWith("LogEventFactory");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.logging.log4j.core.impl.LogEventFactory").or(ElementMatchers.named("org.apache.logging.log4j.core.impl.LocationAwareLogEventFactory")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("createEvent");
    }

    public static class Log4J2_7PlusLogCorrelationInstrumentation
    extends Log4j2LogCorrelationInstrumentation {
        @Override
        public ElementMatcher.Junction<ProtectionDomain> getProtectionDomainPostFilter() {
            return CustomElementMatchers.implementationVersionGte("2.7");
        }

        public static class AdviceClass {
            private static final Log4j2_7PlusLogCorrelationHelper helper = new Log4j2_7PlusLogCorrelationHelper();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static boolean addToThreadContext() {
                return helper.beforeLoggingEvent();
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void removeFromThreadContext(@Advice.Enter boolean addedToThreadContext) {
                helper.afterLoggingEvent(addedToThreadContext);
            }
        }
    }

    public static class Log4J2_6LogCorrelationInstrumentation
    extends Log4j2LogCorrelationInstrumentation {
        @Override
        public ElementMatcher.Junction<ProtectionDomain> getProtectionDomainPostFilter() {
            return CustomElementMatchers.implementationVersionGte("2.6").and(ElementMatchers.not(CustomElementMatchers.implementationVersionGte("2.7")));
        }

        public static class AdviceClass {
            private static final Log4j2_6LogCorrelationHelper helper = new Log4j2_6LogCorrelationHelper();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static boolean addToThreadContext() {
                return helper.beforeLoggingEvent();
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void removeFromThreadContext(@Advice.Enter boolean addedToMdc) {
                helper.afterLoggingEvent(addedToMdc);
            }
        }
    }
}

