/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.lettuce;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.lettuce.Lettuce34Instrumentation;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import com.lambdaworks.redis.protocol.RedisCommand;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Lettuce34StartSpanInstrumentation
extends Lettuce34Instrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.lambdaworks.redis.RedisChannelHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("dispatch").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.not(ElementMatchers.isPrivate()));
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object beforeDispatch(@Nullable @Advice.Argument(value=0) RedisCommand<?, ?, ?> command) {
            Span span;
            if (command != null && (span = RedisSpanUtils.createRedisSpan(command.getType().toString())) != null) {
                Lettuce34Instrumentation.commandToSpan.put(command, span);
                return span;
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void afterDispatch(@Nullable @Advice.Enter Object spanObj) {
            Span span = (Span)spanObj;
            if (span != null) {
                span.deactivate();
            }
        }
    }
}

